package junkutil.crypt;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

/**
 * ʌÍ/ASYB
 * DES,gvDES,AES,RC2,RC4ɑΉ
 * @author Hiroyuki Shiota
 */
public class DES {
	public static final String DES_ALGORITHM = "DES";
	public static final String DESEDE_ALGORITHM = "DESede";
	public static final String AES_ALGORITHM = "AES";
	public static final String BLOWFISH_ALGORITHM = "Blowfish";
	public static final String RC2_ALGORITHM = "RC2";
	public static final String RC4_ALGORITHM = "RC4";
	private String algorithm = DES_ALGORITHM;

	/**
	 * ftHg̃ASY
	 */
	public DES() {
	}

	/**
	 * ASYw肷RXgN^
	 * @param algorithm
	 */
	public DES(String algorithm) {
		this.algorithm = algorithm;
	}

	/**
	 * BASE64ŃGR[h
	 * @param bytes
	 * @return
	 */
	public static String encodeBASE64(byte[] bytes) {
		//return (new BASE64Encoder()).encodeBuffer(bytes);
		return BASE64.encodeBytes(bytes);
	}

	/**
	 * BASE64ŃfR[h
	 * @param value
	 * @return
	 * @throws IOException
	 */
	public static byte[] decodeBASE64(String value) throws IOException {
		//return (new BASE64Decoder()).decodeBuffer(value);
		return BASE64.decode(value);
	}

	/**
	 * L[i_j
	 * @return
	 * @throws NoSuchAlgorithmException
	 * @throws IOException
	 */
	public String createKey() throws NoSuchAlgorithmException, IOException {
		return createKey(null);
	}

	/**
	 * L[iwj
	 * @param seed
	 * @return
	 * @throws NoSuchAlgorithmException
	 * @throws IOException
	 */
	public String createKey(String seed) throws NoSuchAlgorithmException, IOException {
		SecureRandom secureRandom = null;
		if (seed != null) {
			secureRandom = new SecureRandom(decodeBASE64(seed));
		} else {
			secureRandom = new SecureRandom();
		}
		KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
		keyGenerator.init(secureRandom);
		SecretKey secretKey = keyGenerator.generateKey();
		return encodeBASE64(secretKey.getEncoded());
	}

	/**
	 * L[̎擾B
	 * @param key
	 */
	private Key asKey(byte[] key) {
		SecretKey secretKey = new SecretKeySpec(key, algorithm);
		return secretKey;
	}

	/**
	 * ÍB
	 * @param data
	 * @param key
	 * @return
	 * @throws IOException
	 * @throws NoSuchAlgorithmException
	 * @throws NoSuchPaddingException
	 * @throws InvalidKeyException
	 * @throws IllegalBlockSizeException
	 * @throws BadPaddingException
	 */
	public byte[] encrypt(byte[] data, String key) throws IOException, NoSuchAlgorithmException,
			NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
		Key secretKey = asKey(decodeBASE64(key));
		Cipher cipher = Cipher.getInstance(algorithm);
		cipher.init(Cipher.ENCRYPT_MODE, secretKey);
		return cipher.doFinal(data);
	}

	/**
	 * B
	 * @param data
	 * @param key
	 * @return
	 * @throws IOException
	 * @throws NoSuchAlgorithmException
	 * @throws NoSuchPaddingException
	 * @throws InvalidKeyException
	 * @throws IllegalBlockSizeException
	 * @throws BadPaddingException
	 */
	public byte[] decrypt(byte[] data, String key) throws IOException, NoSuchAlgorithmException,
			NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
		Key secretKey = asKey(decodeBASE64(key));
		Cipher cipher = Cipher.getInstance(algorithm);
		cipher.init(Cipher.DECRYPT_MODE, secretKey);
		return cipher.doFinal(data);
	}

}
