package junkutil.gui;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

/**
 * Œ蒷̃eLXg̓tB[h
 * @author Hiroyuki Shiota
 */
public class LzFixedNumberField  extends JTextField {

	private int maxLength = -1;

	/**
	 * ͉\񒷂擾
	 * @return
	 */
	public int getMaxLength() {
		return maxLength;
	}

	/**
	 * ͉\񒷂ݒ肷
	 * @param arg
	 */
	public void setMaxLength(int arg) {
		maxLength = arg;
	}

	/**
	 * RXgN^
	 * @param cols
	 */
	public LzFixedNumberField(int cols) {
		super(cols);
	}

	/**
	 * RXgN^
	 * @param cols
	 * @param maxLength
	 */
	public LzFixedNumberField(int cols, int maxLength) {
		super(cols);
		this.maxLength = maxLength;
	}

	protected Document createDefaultModel() {
		return new LzFixedNumberDocument();
	}

	class LzFixedNumberDocument extends PlainDocument {
		public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
			if (str == null) {
				return;
			}
			str = str.replaceAll("[^\\-+\\.0-9]", "");
			if(maxLength != -1 && maxLength < (getLength()+str.length())) {
				str=str.substring(0, maxLength-getLength());
			}
			super.insertString(offs, str, a);
		}
	}

	/**
	 * intǂԂ
	 * @return
	 */
	public boolean isInt() {
		try {
			Integer.parseInt(getText());
			return true;
		} catch (NumberFormatException e) {
			return false;
		}
	}

	/**
	 * int̒lԂ
	 * @return
	 */
	public int getInt() {
		try {
			return Integer.parseInt(getText());
		} catch (NumberFormatException e) {
			return -1;
		}
	}

	/**
	 * doubleǂԂ
	 * @return
	 */
	public boolean isDouble() {
		try {
			Double.parseDouble(getText());
			return true;
		} catch (NumberFormatException e) {
			return false;
		}
	}

	/**
	 * double̒lԂ
	 * @return
	 */
	public double getDouble() {
		try {
			return Double.parseDouble(getText());
		} catch (NumberFormatException e) {
			return -1d;
		}
	}
}