/*
 * Decompiled with CFR 0.152.
 */
package junkutil.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static final String ln = System.getProperty("line.separator");

    private FileUtil() {
    }

    public static boolean exists(String filename) {
        return new File(filename).exists();
    }

    public static String getExtension(String str) {
        int last = -1;
        int start = 0;
        int index = -1;
        while ((index = str.indexOf(File.separator, start)) != -1) {
            last = index;
            start = index + 1;
        }
        if (last != -1) {
            str = str.substring(last + 1);
        }
        last = -1;
        start = 0;
        index = -1;
        while ((index = str.indexOf(46, start)) != -1) {
            last = index;
            start = index + 1;
        }
        if (last == -1) {
            return "";
        }
        return str.substring(last + 1);
    }

    public static String readFile(String filename) throws IOException {
        return FileUtil.readFile(filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String filename, String encoding) throws IOException {
        BufferedReader br = null;
        StringBuffer result = new StringBuffer();
        try {
            String line;
            br = encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            ArrayList<String> temp = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                temp.add(line);
            }
            for (int i = 0; i < temp.size(); ++i) {
                result.append((String)temp.get(i));
                if (i + 1 >= temp.size()) continue;
                result.append(ln);
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception ee) {}
        }
        return new String(result);
    }

    public static List readLines(String filename) throws IOException {
        return FileUtil.readLines(filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List readLines(String filename, String encoding) throws IOException {
        BufferedReader br = null;
        ArrayList<String> result = null;
        try {
            String line;
            br = encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            result = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception ee) {}
        }
        return result;
    }

    public static void writeLines(String filename, List list) throws IOException {
        FileUtil.writeLines(filename, list, null, false);
    }

    public static void writeLines(String filename, List list, String encoding) throws IOException {
        FileUtil.writeLines(filename, list, encoding, false);
    }

    public static void appendLines(String filename, List list) throws IOException {
        FileUtil.writeLines(filename, list, null, true);
    }

    public static void appendLines(String filename, List list, String encoding) throws IOException {
        FileUtil.writeLines(filename, list, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLines(String filename, List list, String encoding, boolean append) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, append), encoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append)));
            for (int i = 0; i < list.size(); ++i) {
                String line = (String)list.get(i);
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception ee) {}
        }
    }

    public static void writeFile(String filename, String text) throws IOException {
        FileUtil.writeFile(filename, text, null, false);
    }

    public static void writeFile(String filename, String text, String encoding) throws IOException {
        FileUtil.writeFile(filename, text, encoding, false);
    }

    public static void appendFile(String filename, String text) throws IOException {
        FileUtil.writeFile(filename, text, null, true);
    }

    public static void appendFile(String filename, String text, String encoding) throws IOException {
        FileUtil.writeFile(filename, text, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String filename, String text, String encoding, boolean append) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, append), encoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append)));
            bw.write(text);
            bw.flush();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception ee) {}
        }
    }

    public static void writeLine(String filename, String line) throws IOException {
        FileUtil.writeLine(filename, line, null, false);
    }

    public static void writeLine(String filename, String line, String encoding) throws IOException {
        FileUtil.writeLine(filename, line, encoding, false);
    }

    public static void appendLine(String filename, String line) throws IOException {
        FileUtil.writeLine(filename, line, null, true);
    }

    public static void appendLine(String filename, String line, String encoding) throws IOException {
        FileUtil.writeLine(filename, line, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLine(String filename, String line, String encoding, boolean append) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, append), encoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append)));
            bw.write(line);
            bw.write(ln);
            bw.flush();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception ee) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String from, String to) throws IOException {
        FileChannel fromChanell = new FileInputStream(from).getChannel();
        FileChannel toChannel = new FileOutputStream(to).getChannel();
        try {
            fromChanell.transferTo(0L, fromChanell.size(), toChannel);
        }
        finally {
            fromChanell.close();
            toChannel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readByteArray(String filename, int buffSize) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] buff = new byte[buffSize];
        FileInputStream in = null;
        try {
            in = new FileInputStream(filename);
            int len = 0;
            while ((len = in.read(buff, 0, buff.length)) >= 0) {
                buffer.write(buff, 0, len);
            }
            buffer.flush();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return buffer.toByteArray();
    }

    public static void writeByteArray(String filename, byte[] byteArray) throws IOException {
        FileUtil.writeByteArray(filename, byteArray, false);
    }

    public static void appendByteArray(String filename, byte[] byteArray) throws IOException {
        FileUtil.writeByteArray(filename, byteArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeByteArray(String filename, byte[] byteArray, boolean append) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename, append);
            out.write(byteArray);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

