/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink.analyze;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.stormcat.commons.constants.Charset;
import org.stormcat.commons.lang.EnumUtil;
import org.stormcat.commons.lang.StringUtil;
import org.stormcat.commons.reflect.ClassUtil;
import org.stormcat.commons.reflect.MethodUtil;
import org.stormcat.jvbeans.config.RecordTypeId;
import org.stormcat.jvbeans.exception.JvBeansRuntimeException;
import org.stormcat.jvbeans.jvlink.JvBindingDto;
import org.stormcat.jvbeans.jvlink.analyze.JvBeansContainer;
import org.stormcat.jvbeans.jvlink.analyze.JvBindingObjectConverter;
import org.stormcat.jvbeans.jvlink.analyze.JvRecordMeta;
import org.stormcat.jvbeans.util.JvStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvBindingDtoFactory {
    private JvBeansContainer jvBeansContainer;

    public JvBindingDto create(String str) {
        if (StringUtil.isBlank((String)str)) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u304c\u7a7a\u3067\u3059");
        }
        RecordTypeId recordTypeId = (RecordTypeId)((Object)EnumUtil.getEnum(RecordTypeId.class, (String)str.substring(0, 2)));
        if (recordTypeId == null) {
            throw new JvBeansRuntimeException("\u30ec\u30b3\u30fc\u30c9\u7a2e\u5225ID\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (this.jvBeansContainer == null) {
            throw new IllegalStateException("JVBindingDtoFactory\u306e\u30d7\u30ed\u30d1\u30c6\u30a3(jvBeansContainer)\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        JvBindingDto dto = (JvBindingDto)JvBindingDto.class.cast(ClassUtil.newInstance(this.jvBeansContainer.getMappedType(recordTypeId)));
        return this.createDto(str, recordTypeId, dto);
    }

    public <T extends JvBindingDto> T create(String str, Class<T> clazz) {
        if (StringUtil.isBlank((String)str)) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u304c\u7a7a\u3067\u3059");
        }
        RecordTypeId recordTypeId = (RecordTypeId)((Object)EnumUtil.getEnum(RecordTypeId.class, (String)str.substring(0, 2)));
        if (recordTypeId == null) {
            throw new JvBeansRuntimeException("\u30ec\u30b3\u30fc\u30c9\u7a2e\u5225ID\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (this.jvBeansContainer == null) {
            throw new IllegalStateException("JVBindingDtoFactory\u306e\u30d7\u30ed\u30d1\u30c6\u30a3(jvBeansContainer)\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        JvBindingDto dto = (JvBindingDto)ClassUtil.newInstance(clazz);
        return (T)this.createDto(str, recordTypeId, dto);
    }

    private <T extends JvBindingDto> T createDto(String str, RecordTypeId recordTypeId, T dto) {
        byte[] bt = StringUtil.getBytes((String)str, (Charset)Charset.MS932);
        this.bindProperty(this.jvBeansContainer.getRecordMetaItems(recordTypeId), dto, bt);
        dto.setLine(str);
        return dto;
    }

    private <T> void bindProperty(List<JvRecordMeta> metaItems, T dto, byte[] bt) {
        for (JvRecordMeta meta : metaItems) {
            byte[] parts = null;
            List<JvRecordMeta> joinItems = meta.getJoinMetaItems();
            if (meta.getRepeatCount() == 1) {
                parts = this.subarray(bt, meta.getPosition(), meta.getByteLength());
                this.setProperty(parts, meta, dto);
                continue;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < meta.getRepeatCount(); ++i) {
                Object child = null;
                parts = this.subarray(bt, i * meta.getByteLength() + meta.getPosition(), meta.getByteLength());
                if (joinItems == null) {
                    child = this.convert(parts, meta);
                } else {
                    child = ClassUtil.newInstance(meta.getType());
                    this.bindProperty(joinItems, child, parts);
                }
                list.add(child);
            }
            MethodUtil.invoke((Method)meta.getMutator(), dto, null, (Object[])new Object[]{list});
        }
    }

    private void setProperty(byte[] data, JvRecordMeta meta, Object target) {
        Object value = this.convert(data, meta);
        Method mutator = meta.getMutator();
        if (mutator == null) {
            throw new JvBeansRuntimeException("\u30bb\u30c3\u30bf\u30fc\u30e1\u30bd\u30c3\u30c9\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        MethodUtil.invoke((Method)mutator, (Object)target, null, (Object[])new Object[]{value});
    }

    private Object convert(byte[] data, JvRecordMeta meta) {
        String rawData = JvStringUtil.trim(StringUtil.getString((byte[])data, (Charset)Charset.MS932));
        return JvBindingObjectConverter.convert(rawData, meta);
    }

    private byte[] subarray(byte[] data, int position, int byteLength) {
        return ArrayUtils.subarray((byte[])data, (int)(position - 1), (int)(position + byteLength - 1));
    }

    public void setJvBeansContainer(JvBeansContainer jvBeansContainer) {
        this.jvBeansContainer = jvBeansContainer;
    }
}

