/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink.analyze;

import java.util.Date;
import org.stormcat.commons.lang.DateUtil;
import org.stormcat.commons.lang.DoubleUtil;
import org.stormcat.commons.lang.FloatUtil;
import org.stormcat.commons.lang.IntegerUtil;
import org.stormcat.commons.lang.LongUtil;
import org.stormcat.commons.lang.StringUtil;
import org.stormcat.jvbeans.jvlink.analyze.JvRecordMeta;
import org.stormcat.jvbeans.util.PairValueEnumUtil;

public class JvBindingObjectConverter {
    private JvBindingObjectConverter() {
    }

    public static Object convert(String target, JvRecordMeta meta) {
        Class<?> type = meta.getType();
        float correction = meta.getCorrection();
        if (PairValueEnumUtil.isImplementsPairValueEnum(type)) {
            return PairValueEnumUtil.getPairValueEnum(type, target);
        }
        if (String.class == type) {
            return StringUtil.isNotBlank((String)target) ? target : null;
        }
        if (Integer.class == type) {
            Integer i = IntegerUtil.convert((String)target);
            if (i == null) {
                return i;
            }
            return (int)((float)i.intValue() * correction);
        }
        if (Float.class == type) {
            Float f = FloatUtil.convert((String)target);
            if (f == null) {
                return f;
            }
            return Float.valueOf(f.floatValue() * correction);
        }
        if (Long.class == type) {
            Long l = LongUtil.convert((String)target);
            if (l == null) {
                return l;
            }
            return (long)((float)l.longValue() * correction);
        }
        if (Double.class == type) {
            Double d = DoubleUtil.convert((String)target);
            if (d == null) {
                return d;
            }
            return d * (double)correction;
        }
        if (Date.class == type) {
            return DateUtil.parseDate((String)target, (String)"yyyyMMdd");
        }
        return null;
    }
}

