/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.config;

import org.stormcat.commons.constants.PairValueEnum;

/**
 * レコード種別IDのEnumによる表現です。
 * @author a.yamada
 *
 */
public enum RecordTypeId implements PairValueEnum<String> {
    
    /** 特別登録馬 */
    TK("特別登録馬", "TK"),
    
    /** レース詳細 */
    RA("レース詳細", "RA"),
    
    /** 馬毎レース情報 */
    SE("馬毎レース情報", "SE"),
    
    /** 払戻 */
    HR("払戻", "HR"),
    
    /** 票数1 */
    H1("票数1", "H1"),
    
    /** 票数6*/
    H6("票数6（3連単）", "H6"),
    
    /** オッズ1 */
    O1("オッズ1（単複枠）", "O1"),
    
    /** オッズ2 */
    O2("オッズ2（馬連）", "O2"),
    
    /** オッズ3 */
    O3("オッズ3（ワイド）", "O3"),
    
    /** オッズ4 */
    O4("オッズ4（馬単）", "O4"),
    
    /** オッズ5 */
    O5("オッズ5（３連複）", "O5"),
    
    /** オッズ6 */
    O6("オッズ6（３連単）", "O6"),
    
    /** 競走馬マスタ */
    UM("競走馬マスタ", "UM"),
    
    /** 騎手マスタ */
    KS("騎手マスタ", "KS"),
    
    /** 調教師マスタ */
    CH("調教師マスタ", "CH"),
    
    /** 生産者マスタ */
    BR("生産者マスタ", "BR"),
    
    /** 馬主マスタ */
    BN("馬主マスタ", "BN"),
    
    /** 繁殖馬マスタ */
    HN("繁殖馬マスタ", "HN"),
    
    /** 産駒マスタ */
    SK("産駒マスタ", "SK"),
    
    /** 出走別着度数 */
    CK("出走別着度数", "CK"),
    
    /** レコードマスタ */
    RC("レコードマスタ", "RC"),
    
    /** 坂路調教 */
    HC("坂路調教", "HC"),
    
    /** 競走馬市場取引価格 */
    HS("競走馬市場取引価格", "HS"),
    
    /** 馬名の意味由来情報 */
    HY("馬名の意味由来情報", "HY"),
    
    /** 開催スケジュール */
    YS("開催スケジュール", "YS"),
    
    /** 系統情報 */
    BT("系統情報", "BT"),
    
    /** コース情報 */
    CS("コース情報", "CS"),
    
    /** データマイニング予想 */
    DM("データマイニング予想", "DM"),
    
    /** 馬体重 */
    WH("馬体重", "WH"),
    
    /** 天候馬場状態 */
    WE("天候馬場状態", "WE"),
    
    /** 出走取消･競走除外 */
    AV("出走取消･競走除外", "AV"),
    
    /** 騎手変更 */
    JC("騎手変更", "JC"),
    
    /** 発走時刻変更 */
    TC("発走時刻変更", "TC"),
    
    /** コース変更 */
    CC("コース変更", "CC");

    /** 名称 */
    private String name;
    
    /** 値 */
    private String value;
    
    /**
     * 
     * コンストラクタ
     * @param name 名称
     * @param value 値
     */
    private RecordTypeId(String name, String value) {
        this.name = name;
        this.value = value;
    }
    
    /**
     * {@inheritDoc}
     */
    public String getName() {
        return name;
    }

    /**
     * {@inheritDoc}
     */
    public String getValue() {
        return value;
    }
    
}
