/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.config.dataspec;

import org.stormcat.jvbeans.config.RecordTypeId;
import org.stormcat.jvbeans.config.condition.StoredOpenCondition;
import org.stormcat.jvbeans.dto.HorseRaceInfoDto;
import org.stormcat.jvbeans.dto.Odds1Dto;
import org.stormcat.jvbeans.dto.Odds2Dto;
import org.stormcat.jvbeans.dto.Odds3Dto;
import org.stormcat.jvbeans.dto.Odds4Dto;
import org.stormcat.jvbeans.dto.Odds5Dto;
import org.stormcat.jvbeans.dto.Odds6Dto;
import org.stormcat.jvbeans.dto.RaceDetailDto;
import org.stormcat.jvbeans.dto.RefundDto;
import org.stormcat.jvbeans.dto.VoteCount1Dto;
import org.stormcat.jvbeans.dto.VoteCount6Dto;

/**
 * @author a.yamada
 *
 */
public enum _Race implements org.stormcat.jvbeans.config.dataspec.StoredDataSpec {

    INSTANCE;
    
    public StoredOpenCondition<RaceDetailDto> _RA() {
        return new StoredOpenCondition<RaceDetailDto>(this, RecordTypeId.RA, RaceDetailDto.class);
    }
    
    public StoredOpenCondition<HorseRaceInfoDto> _SE() {
        return new StoredOpenCondition<HorseRaceInfoDto>(this, RecordTypeId.SE, HorseRaceInfoDto.class);
    }
    
    public StoredOpenCondition<RefundDto> _HR() {
        return new StoredOpenCondition<RefundDto>(this, RecordTypeId.HR, RefundDto.class);
    }
    
    public StoredOpenCondition<VoteCount1Dto> _H1() {
        return new StoredOpenCondition<VoteCount1Dto>(this, RecordTypeId.H1, VoteCount1Dto.class);
    }
    
    public StoredOpenCondition<VoteCount6Dto> _H6() {
        return new StoredOpenCondition<VoteCount6Dto>(this, RecordTypeId.H6, VoteCount6Dto.class);
    }
    
    public StoredOpenCondition<Odds1Dto> _O1() {
        return new StoredOpenCondition<Odds1Dto>(this, RecordTypeId.O1, Odds1Dto.class);
    }
    
    public StoredOpenCondition<Odds2Dto> _O2() {
        return new StoredOpenCondition<Odds2Dto>(this, RecordTypeId.O2, Odds2Dto.class);
    }
    
    public StoredOpenCondition<Odds3Dto> _O3() {
        return new StoredOpenCondition<Odds3Dto>(this, RecordTypeId.O3, Odds3Dto.class);
    }

    public StoredOpenCondition<Odds4Dto> _O4() {
        return new StoredOpenCondition<Odds4Dto>(this, RecordTypeId.O4, Odds4Dto.class);
    }
    
    public StoredOpenCondition<Odds5Dto> _O5() {
        return new StoredOpenCondition<Odds5Dto>(this, RecordTypeId.O5, Odds5Dto.class);
    }
    
    public StoredOpenCondition<Odds6Dto> _O6() {
        return new StoredOpenCondition<Odds6Dto>(this, RecordTypeId.O6, Odds6Dto.class);
    }

    /**
     * {@inheritDoc}
     */
    public String getName() {
        return "レース情報";
    }

    /**
     * {@inheritDoc}
     */
    public String getValue() {
        return "RACE";
    }

}
