/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.dto;
 
 /**
 * レコードフォーマットID {@link org.stormcat.jvbeans.config.RecordTypeId.BT} に対応するDtoです。
 * @author jv-beans-gen
 *
 */
@org.stormcat.jvbeans.annotation.JvBean(recordTypeId = org.stormcat.jvbeans.config.RecordTypeId.BT, byteLength = 6887)
public class AncestryInfoDto extends org.stormcat.jvbeans.jvlink.JvBindingDto {

    /** レコード種別ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1, byteLength = 2)
    private org.stormcat.jvbeans.config.RecordTypeId recordTypeId;

    /** データ区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 3, byteLength = 1)
    private java.lang.String dataDiv;

    /** データ作成年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4, byteLength = 8)
    private java.util.Date dataCreateDate;

    /** 繁殖登録番号 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12, byteLength = 8)
    private java.lang.String breedingRegistNo;

    /** 系統ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 20, byteLength = 30)
    private java.lang.String ancestryId;

    /** 系統名 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 50, byteLength = 36)
    private java.lang.String ancestryName;

    /** 系統説明 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 86, byteLength = 6800)
    private java.lang.String ancestryDescription;


    /**
     * @return レコード種別ID
     */
    public org.stormcat.jvbeans.config.RecordTypeId getRecordTypeId() {
        return recordTypeId;
    }
    
    /**
     * @param recordTypeId レコード種別ID
     */
    public void setRecordTypeId(org.stormcat.jvbeans.config.RecordTypeId recordTypeId) {
        this.recordTypeId = recordTypeId;
    }    
    
    /**
     * @return データ区分
     */
    public java.lang.String getDataDiv() {
        return dataDiv;
    }
    
    /**
     * @param dataDiv データ区分
     */
    public void setDataDiv(java.lang.String dataDiv) {
        this.dataDiv = dataDiv;
    }    
    
    /**
     * @return データ作成年月日
     */
    public java.util.Date getDataCreateDate() {
        return dataCreateDate;
    }
    
    /**
     * @param dataCreateDate データ作成年月日
     */
    public void setDataCreateDate(java.util.Date dataCreateDate) {
        this.dataCreateDate = dataCreateDate;
    }    
    
    /**
     * @return 繁殖登録番号
     */
    public java.lang.String getBreedingRegistNo() {
        return breedingRegistNo;
    }
    
    /**
     * @param breedingRegistNo 繁殖登録番号
     */
    public void setBreedingRegistNo(java.lang.String breedingRegistNo) {
        this.breedingRegistNo = breedingRegistNo;
    }    
    
    /**
     * @return 系統ID
     */
    public java.lang.String getAncestryId() {
        return ancestryId;
    }
    
    /**
     * @param ancestryId 系統ID
     */
    public void setAncestryId(java.lang.String ancestryId) {
        this.ancestryId = ancestryId;
    }    
    
    /**
     * @return 系統名
     */
    public java.lang.String getAncestryName() {
        return ancestryName;
    }
    
    /**
     * @param ancestryName 系統名
     */
    public void setAncestryName(java.lang.String ancestryName) {
        this.ancestryName = ancestryName;
    }    
    
    /**
     * @return 系統説明
     */
    public java.lang.String getAncestryDescription() {
        return ancestryDescription;
    }
    
    /**
     * @param ancestryDescription 系統説明
     */
    public void setAncestryDescription(java.lang.String ancestryDescription) {
        this.ancestryDescription = ancestryDescription;
    }    
    
}