/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.dto;
 
 /**
 * レコードフォーマットID {@link org.stormcat.jvbeans.config.RecordTypeId.KS} に対応するDtoです。
 * @author jv-beans-gen
 *
 */
@org.stormcat.jvbeans.annotation.JvBean(recordTypeId = org.stormcat.jvbeans.config.RecordTypeId.KS, byteLength = 4173)
public class JockeyMasterDto extends org.stormcat.jvbeans.jvlink.JvBindingDto {

    /** レコード種別ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1, byteLength = 2)
    private org.stormcat.jvbeans.config.RecordTypeId recordTypeId;

    /** データ区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 3, byteLength = 1)
    private java.lang.String dataDiv;

    /** データ作成年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4, byteLength = 8)
    private java.util.Date dataCreateDate;

    /** 騎手コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12, byteLength = 5)
    private java.lang.String jockeyCd;

    /** 騎手抹消区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 17, byteLength = 1)
    private java.lang.Integer jockeyEraseDiv;

    /** 騎手免許交付年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 18, byteLength = 8)
    private java.util.Date jockeyLicenseIssueDate;

    /** 騎手免許抹消年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 26, byteLength = 8)
    private java.util.Date jockeyLicenseEraseDate;

    /** 生年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 34, byteLength = 8)
    private java.util.Date birthDate;

    /** 騎手名 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 42, byteLength = 34)
    private java.lang.String jockeyName;

    /** 予備 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 76, byteLength = 34)
    private java.lang.String spare1;

    /** 騎手名半角ｶﾅ */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 110, byteLength = 30)
    private java.lang.String jockeyNameHalfKana;

    /** 騎手名略称 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 140, byteLength = 8)
    private java.lang.String jockeyNameShort;

    /** 騎手名欧字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 148, byteLength = 80)
    private java.lang.String jockeyNameEng;

    /** 性別区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 228, byteLength = 1)
    private java.lang.Integer sexDiv;

    /** 騎乗資格コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 229, byteLength = 1)
    private org.stormcat.jvbeans.config.code.RidingQualificationCd ridingQualificationCd;

    /** 騎手見習コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 230, byteLength = 1)
    private org.stormcat.jvbeans.config.code.JockeyMateCd jockeyMateCd;

    /** 騎手東西所属コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 231, byteLength = 1)
    private org.stormcat.jvbeans.config.code.EWBelongCd jockeryEWBelongCd;

    /** 招待地域名 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 232, byteLength = 20)
    private java.lang.String invitationAreaName;

    /** 所属調教師コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 252, byteLength = 5)
    private java.lang.String belongingTrainerCd;

    /** 所属調教師名略称 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 257, byteLength = 8)
    private java.lang.String belongingTrainerNameShort;

    /** 初騎乗情報 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 265, byteLength = 67, repeatCount = 2)
    private java.util.List<org.stormcat.jvbeans.dto.child.FirstRidingInfoDto> firstRingingInfoItems;

    /** 初勝利情報 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 399, byteLength = 64, repeatCount = 2)
    private java.util.List<org.stormcat.jvbeans.dto.child.FirstWinningInfoDto> firstWinningInfoItems;

    /** 最近重賞勝利情報 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 527, byteLength = 163, repeatCount = 3)
    private java.util.List<org.stormcat.jvbeans.dto.child.GradeWinningRecentlyInfoDto> gradeWinningRecentlyInfoItems;

    /** 本年･前年･累計成績情報 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1016, byteLength = 1052, repeatCount = 3)
    private java.util.List<org.stormcat.jvbeans.dto.child.TotalResultInfoMiddleDto> totalResultInfoItems;


    /**
     * @return レコード種別ID
     */
    public org.stormcat.jvbeans.config.RecordTypeId getRecordTypeId() {
        return recordTypeId;
    }
    
    /**
     * @param recordTypeId レコード種別ID
     */
    public void setRecordTypeId(org.stormcat.jvbeans.config.RecordTypeId recordTypeId) {
        this.recordTypeId = recordTypeId;
    }    
    
    /**
     * @return データ区分
     */
    public java.lang.String getDataDiv() {
        return dataDiv;
    }
    
    /**
     * @param dataDiv データ区分
     */
    public void setDataDiv(java.lang.String dataDiv) {
        this.dataDiv = dataDiv;
    }    
    
    /**
     * @return データ作成年月日
     */
    public java.util.Date getDataCreateDate() {
        return dataCreateDate;
    }
    
    /**
     * @param dataCreateDate データ作成年月日
     */
    public void setDataCreateDate(java.util.Date dataCreateDate) {
        this.dataCreateDate = dataCreateDate;
    }    
    
    /**
     * @return 騎手コード
     */
    public java.lang.String getJockeyCd() {
        return jockeyCd;
    }
    
    /**
     * @param jockeyCd 騎手コード
     */
    public void setJockeyCd(java.lang.String jockeyCd) {
        this.jockeyCd = jockeyCd;
    }    
    
    /**
     * @return 騎手抹消区分
     */
    public java.lang.Integer getJockeyEraseDiv() {
        return jockeyEraseDiv;
    }
    
    /**
     * @param jockeyEraseDiv 騎手抹消区分
     */
    public void setJockeyEraseDiv(java.lang.Integer jockeyEraseDiv) {
        this.jockeyEraseDiv = jockeyEraseDiv;
    }    
    
    /**
     * @return 騎手免許交付年月日
     */
    public java.util.Date getJockeyLicenseIssueDate() {
        return jockeyLicenseIssueDate;
    }
    
    /**
     * @param jockeyLicenseIssueDate 騎手免許交付年月日
     */
    public void setJockeyLicenseIssueDate(java.util.Date jockeyLicenseIssueDate) {
        this.jockeyLicenseIssueDate = jockeyLicenseIssueDate;
    }    
    
    /**
     * @return 騎手免許抹消年月日
     */
    public java.util.Date getJockeyLicenseEraseDate() {
        return jockeyLicenseEraseDate;
    }
    
    /**
     * @param jockeyLicenseEraseDate 騎手免許抹消年月日
     */
    public void setJockeyLicenseEraseDate(java.util.Date jockeyLicenseEraseDate) {
        this.jockeyLicenseEraseDate = jockeyLicenseEraseDate;
    }    
    
    /**
     * @return 生年月日
     */
    public java.util.Date getBirthDate() {
        return birthDate;
    }
    
    /**
     * @param birthDate 生年月日
     */
    public void setBirthDate(java.util.Date birthDate) {
        this.birthDate = birthDate;
    }    
    
    /**
     * @return 騎手名
     */
    public java.lang.String getJockeyName() {
        return jockeyName;
    }
    
    /**
     * @param jockeyName 騎手名
     */
    public void setJockeyName(java.lang.String jockeyName) {
        this.jockeyName = jockeyName;
    }    
    
    /**
     * @return 予備
     */
    public java.lang.String getSpare1() {
        return spare1;
    }
    
    /**
     * @param spare1 予備
     */
    public void setSpare1(java.lang.String spare1) {
        this.spare1 = spare1;
    }    
    
    /**
     * @return 騎手名半角ｶﾅ
     */
    public java.lang.String getJockeyNameHalfKana() {
        return jockeyNameHalfKana;
    }
    
    /**
     * @param jockeyNameHalfKana 騎手名半角ｶﾅ
     */
    public void setJockeyNameHalfKana(java.lang.String jockeyNameHalfKana) {
        this.jockeyNameHalfKana = jockeyNameHalfKana;
    }    
    
    /**
     * @return 騎手名略称
     */
    public java.lang.String getJockeyNameShort() {
        return jockeyNameShort;
    }
    
    /**
     * @param jockeyNameShort 騎手名略称
     */
    public void setJockeyNameShort(java.lang.String jockeyNameShort) {
        this.jockeyNameShort = jockeyNameShort;
    }    
    
    /**
     * @return 騎手名欧字
     */
    public java.lang.String getJockeyNameEng() {
        return jockeyNameEng;
    }
    
    /**
     * @param jockeyNameEng 騎手名欧字
     */
    public void setJockeyNameEng(java.lang.String jockeyNameEng) {
        this.jockeyNameEng = jockeyNameEng;
    }    
    
    /**
     * @return 性別区分
     */
    public java.lang.Integer getSexDiv() {
        return sexDiv;
    }
    
    /**
     * @param sexDiv 性別区分
     */
    public void setSexDiv(java.lang.Integer sexDiv) {
        this.sexDiv = sexDiv;
    }    
    
    /**
     * @return 騎乗資格コード
     */
    public org.stormcat.jvbeans.config.code.RidingQualificationCd getRidingQualificationCd() {
        return ridingQualificationCd;
    }
    
    /**
     * @param ridingQualificationCd 騎乗資格コード
     */
    public void setRidingQualificationCd(org.stormcat.jvbeans.config.code.RidingQualificationCd ridingQualificationCd) {
        this.ridingQualificationCd = ridingQualificationCd;
    }    
    
    /**
     * @return 騎手見習コード
     */
    public org.stormcat.jvbeans.config.code.JockeyMateCd getJockeyMateCd() {
        return jockeyMateCd;
    }
    
    /**
     * @param jockeyMateCd 騎手見習コード
     */
    public void setJockeyMateCd(org.stormcat.jvbeans.config.code.JockeyMateCd jockeyMateCd) {
        this.jockeyMateCd = jockeyMateCd;
    }    
    
    /**
     * @return 騎手東西所属コード
     */
    public org.stormcat.jvbeans.config.code.EWBelongCd getJockeryEWBelongCd() {
        return jockeryEWBelongCd;
    }
    
    /**
     * @param jockeryEWBelongCd 騎手東西所属コード
     */
    public void setJockeryEWBelongCd(org.stormcat.jvbeans.config.code.EWBelongCd jockeryEWBelongCd) {
        this.jockeryEWBelongCd = jockeryEWBelongCd;
    }    
    
    /**
     * @return 招待地域名
     */
    public java.lang.String getInvitationAreaName() {
        return invitationAreaName;
    }
    
    /**
     * @param invitationAreaName 招待地域名
     */
    public void setInvitationAreaName(java.lang.String invitationAreaName) {
        this.invitationAreaName = invitationAreaName;
    }    
    
    /**
     * @return 所属調教師コード
     */
    public java.lang.String getBelongingTrainerCd() {
        return belongingTrainerCd;
    }
    
    /**
     * @param belongingTrainerCd 所属調教師コード
     */
    public void setBelongingTrainerCd(java.lang.String belongingTrainerCd) {
        this.belongingTrainerCd = belongingTrainerCd;
    }    
    
    /**
     * @return 所属調教師名略称
     */
    public java.lang.String getBelongingTrainerNameShort() {
        return belongingTrainerNameShort;
    }
    
    /**
     * @param belongingTrainerNameShort 所属調教師名略称
     */
    public void setBelongingTrainerNameShort(java.lang.String belongingTrainerNameShort) {
        this.belongingTrainerNameShort = belongingTrainerNameShort;
    }    
    
    /**
     * @return 初騎乗情報
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.FirstRidingInfoDto> getFirstRingingInfoItems() {
        return firstRingingInfoItems;
    }
    
    /**
     * @param firstRingingInfoItems 初騎乗情報
     */
    public void setFirstRingingInfoItems(java.util.List<org.stormcat.jvbeans.dto.child.FirstRidingInfoDto> firstRingingInfoItems) {
        this.firstRingingInfoItems = firstRingingInfoItems;
    }      
    
    /**
     * @return 初勝利情報
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.FirstWinningInfoDto> getFirstWinningInfoItems() {
        return firstWinningInfoItems;
    }
    
    /**
     * @param firstWinningInfoItems 初勝利情報
     */
    public void setFirstWinningInfoItems(java.util.List<org.stormcat.jvbeans.dto.child.FirstWinningInfoDto> firstWinningInfoItems) {
        this.firstWinningInfoItems = firstWinningInfoItems;
    }      
    
    /**
     * @return 最近重賞勝利情報
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.GradeWinningRecentlyInfoDto> getGradeWinningRecentlyInfoItems() {
        return gradeWinningRecentlyInfoItems;
    }
    
    /**
     * @param gradeWinningRecentlyInfoItems 最近重賞勝利情報
     */
    public void setGradeWinningRecentlyInfoItems(java.util.List<org.stormcat.jvbeans.dto.child.GradeWinningRecentlyInfoDto> gradeWinningRecentlyInfoItems) {
        this.gradeWinningRecentlyInfoItems = gradeWinningRecentlyInfoItems;
    }      
    
    /**
     * @return 本年･前年･累計成績情報
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.TotalResultInfoMiddleDto> getTotalResultInfoItems() {
        return totalResultInfoItems;
    }
    
    /**
     * @param totalResultInfoItems 本年･前年･累計成績情報
     */
    public void setTotalResultInfoItems(java.util.List<org.stormcat.jvbeans.dto.child.TotalResultInfoMiddleDto> totalResultInfoItems) {
        this.totalResultInfoItems = totalResultInfoItems;
    }      
    
}