/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.dto;
 
 /**
 * レコードフォーマットID {@link org.stormcat.jvbeans.config.RecordTypeId.BN} に対応するDtoです。
 * @author jv-beans-gen
 *
 */
@org.stormcat.jvbeans.annotation.JvBean(recordTypeId = org.stormcat.jvbeans.config.RecordTypeId.BN, byteLength = 477)
public class OwnerMasterDto extends org.stormcat.jvbeans.jvlink.JvBindingDto {

    /** レコード種別ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1, byteLength = 2)
    private org.stormcat.jvbeans.config.RecordTypeId recordTypeId;

    /** データ区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 3, byteLength = 1)
    private java.lang.String dataDiv;

    /** データ作成年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4, byteLength = 8)
    private java.util.Date dataCreateDate;

    /** 馬主コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12, byteLength = 6)
    private java.lang.String ownerCd;

    /** 馬主名(法人格有) */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 18, byteLength = 64)
    private java.lang.String ownerNameWithCorp;

    /** 馬主名(法人格無) */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 82, byteLength = 64)
    private java.lang.String ownerNameWithoutCorp;

    /** 馬主名半角ｶﾅ */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 146, byteLength = 50)
    private java.lang.String ownerNameHalfKana;

    /** 馬主名欧字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 196, byteLength = 100)
    private java.lang.String ownerNameEng;

    /** 服色標示 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 296, byteLength = 60)
    private java.lang.String clothingMark;

    /** 本年･累計成績情報 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 356, byteLength = 60, repeatCount = 2)
    private java.util.List<org.stormcat.jvbeans.dto.child.TotalResultInfoSimpleDto> totalResultInfoItems;


    /**
     * @return レコード種別ID
     */
    public org.stormcat.jvbeans.config.RecordTypeId getRecordTypeId() {
        return recordTypeId;
    }
    
    /**
     * @param recordTypeId レコード種別ID
     */
    public void setRecordTypeId(org.stormcat.jvbeans.config.RecordTypeId recordTypeId) {
        this.recordTypeId = recordTypeId;
    }    
    
    /**
     * @return データ区分
     */
    public java.lang.String getDataDiv() {
        return dataDiv;
    }
    
    /**
     * @param dataDiv データ区分
     */
    public void setDataDiv(java.lang.String dataDiv) {
        this.dataDiv = dataDiv;
    }    
    
    /**
     * @return データ作成年月日
     */
    public java.util.Date getDataCreateDate() {
        return dataCreateDate;
    }
    
    /**
     * @param dataCreateDate データ作成年月日
     */
    public void setDataCreateDate(java.util.Date dataCreateDate) {
        this.dataCreateDate = dataCreateDate;
    }    
    
    /**
     * @return 馬主コード
     */
    public java.lang.String getOwnerCd() {
        return ownerCd;
    }
    
    /**
     * @param ownerCd 馬主コード
     */
    public void setOwnerCd(java.lang.String ownerCd) {
        this.ownerCd = ownerCd;
    }    
    
    /**
     * @return 馬主名(法人格有)
     */
    public java.lang.String getOwnerNameWithCorp() {
        return ownerNameWithCorp;
    }
    
    /**
     * @param ownerNameWithCorp 馬主名(法人格有)
     */
    public void setOwnerNameWithCorp(java.lang.String ownerNameWithCorp) {
        this.ownerNameWithCorp = ownerNameWithCorp;
    }    
    
    /**
     * @return 馬主名(法人格無)
     */
    public java.lang.String getOwnerNameWithoutCorp() {
        return ownerNameWithoutCorp;
    }
    
    /**
     * @param ownerNameWithoutCorp 馬主名(法人格無)
     */
    public void setOwnerNameWithoutCorp(java.lang.String ownerNameWithoutCorp) {
        this.ownerNameWithoutCorp = ownerNameWithoutCorp;
    }    
    
    /**
     * @return 馬主名半角ｶﾅ
     */
    public java.lang.String getOwnerNameHalfKana() {
        return ownerNameHalfKana;
    }
    
    /**
     * @param ownerNameHalfKana 馬主名半角ｶﾅ
     */
    public void setOwnerNameHalfKana(java.lang.String ownerNameHalfKana) {
        this.ownerNameHalfKana = ownerNameHalfKana;
    }    
    
    /**
     * @return 馬主名欧字
     */
    public java.lang.String getOwnerNameEng() {
        return ownerNameEng;
    }
    
    /**
     * @param ownerNameEng 馬主名欧字
     */
    public void setOwnerNameEng(java.lang.String ownerNameEng) {
        this.ownerNameEng = ownerNameEng;
    }    
    
    /**
     * @return 服色標示
     */
    public java.lang.String getClothingMark() {
        return clothingMark;
    }
    
    /**
     * @param clothingMark 服色標示
     */
    public void setClothingMark(java.lang.String clothingMark) {
        this.clothingMark = clothingMark;
    }    
    
    /**
     * @return 本年･累計成績情報
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.TotalResultInfoSimpleDto> getTotalResultInfoItems() {
        return totalResultInfoItems;
    }
    
    /**
     * @param totalResultInfoItems 本年･累計成績情報
     */
    public void setTotalResultInfoItems(java.util.List<org.stormcat.jvbeans.dto.child.TotalResultInfoSimpleDto> totalResultInfoItems) {
        this.totalResultInfoItems = totalResultInfoItems;
    }      
    
}