/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.dto;
 
 /**
 * レコードフォーマットID {@link org.stormcat.jvbeans.config.RecordTypeId.SK} に対応するDtoです。
 * @author jv-beans-gen
 *
 */
@org.stormcat.jvbeans.annotation.JvBean(recordTypeId = org.stormcat.jvbeans.config.RecordTypeId.SK, byteLength = 178)
public class SonMasterDto extends org.stormcat.jvbeans.jvlink.JvBindingDto {

    /** レコード種別ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1, byteLength = 2)
    private org.stormcat.jvbeans.config.RecordTypeId recordTypeId;

    /** データ区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 3, byteLength = 1)
    private java.lang.String dataDiv;

    /** データ作成年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4, byteLength = 8)
    private java.util.Date dataCreateDate;

    /** 血統登録番号 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12, byteLength = 10)
    private java.lang.String bloodRegistNo;

    /** 生年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 22, byteLength = 8)
    private java.util.Date birthDate;

    /** 性別コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 30, byteLength = 1)
    private org.stormcat.jvbeans.config.code.SexCd sexCd;

    /** 品種コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 31, byteLength = 1)
    private org.stormcat.jvbeans.config.code.BreedCd breedCd;

    /** 毛色コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 32, byteLength = 2)
    private org.stormcat.jvbeans.config.code.HairColorCd hairColorCd;

    /** 産駒持込区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 34, byteLength = 1)
    private java.lang.Integer sonBringingDiv;

    /** 輸入年 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 35, byteLength = 4)
    private java.lang.Integer importYear;

    /** 生産者コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 39, byteLength = 6)
    private java.lang.String breederCd;

    /** 産地名 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 45, byteLength = 20)
    private java.lang.String sourceName;

    /** 3代血統 繁殖登録番号 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 65, byteLength = 8, repeatCount = 14)
    private java.util.List<java.lang.String> breedingRegistNoItems;


    /**
     * @return レコード種別ID
     */
    public org.stormcat.jvbeans.config.RecordTypeId getRecordTypeId() {
        return recordTypeId;
    }
    
    /**
     * @param recordTypeId レコード種別ID
     */
    public void setRecordTypeId(org.stormcat.jvbeans.config.RecordTypeId recordTypeId) {
        this.recordTypeId = recordTypeId;
    }    
    
    /**
     * @return データ区分
     */
    public java.lang.String getDataDiv() {
        return dataDiv;
    }
    
    /**
     * @param dataDiv データ区分
     */
    public void setDataDiv(java.lang.String dataDiv) {
        this.dataDiv = dataDiv;
    }    
    
    /**
     * @return データ作成年月日
     */
    public java.util.Date getDataCreateDate() {
        return dataCreateDate;
    }
    
    /**
     * @param dataCreateDate データ作成年月日
     */
    public void setDataCreateDate(java.util.Date dataCreateDate) {
        this.dataCreateDate = dataCreateDate;
    }    
    
    /**
     * @return 血統登録番号
     */
    public java.lang.String getBloodRegistNo() {
        return bloodRegistNo;
    }
    
    /**
     * @param bloodRegistNo 血統登録番号
     */
    public void setBloodRegistNo(java.lang.String bloodRegistNo) {
        this.bloodRegistNo = bloodRegistNo;
    }    
    
    /**
     * @return 生年月日
     */
    public java.util.Date getBirthDate() {
        return birthDate;
    }
    
    /**
     * @param birthDate 生年月日
     */
    public void setBirthDate(java.util.Date birthDate) {
        this.birthDate = birthDate;
    }    
    
    /**
     * @return 性別コード
     */
    public org.stormcat.jvbeans.config.code.SexCd getSexCd() {
        return sexCd;
    }
    
    /**
     * @param sexCd 性別コード
     */
    public void setSexCd(org.stormcat.jvbeans.config.code.SexCd sexCd) {
        this.sexCd = sexCd;
    }    
    
    /**
     * @return 品種コード
     */
    public org.stormcat.jvbeans.config.code.BreedCd getBreedCd() {
        return breedCd;
    }
    
    /**
     * @param breedCd 品種コード
     */
    public void setBreedCd(org.stormcat.jvbeans.config.code.BreedCd breedCd) {
        this.breedCd = breedCd;
    }    
    
    /**
     * @return 毛色コード
     */
    public org.stormcat.jvbeans.config.code.HairColorCd getHairColorCd() {
        return hairColorCd;
    }
    
    /**
     * @param hairColorCd 毛色コード
     */
    public void setHairColorCd(org.stormcat.jvbeans.config.code.HairColorCd hairColorCd) {
        this.hairColorCd = hairColorCd;
    }    
    
    /**
     * @return 産駒持込区分
     */
    public java.lang.Integer getSonBringingDiv() {
        return sonBringingDiv;
    }
    
    /**
     * @param sonBringingDiv 産駒持込区分
     */
    public void setSonBringingDiv(java.lang.Integer sonBringingDiv) {
        this.sonBringingDiv = sonBringingDiv;
    }    
    
    /**
     * @return 輸入年
     */
    public java.lang.Integer getImportYear() {
        return importYear;
    }
    
    /**
     * @param importYear 輸入年
     */
    public void setImportYear(java.lang.Integer importYear) {
        this.importYear = importYear;
    }    
    
    /**
     * @return 生産者コード
     */
    public java.lang.String getBreederCd() {
        return breederCd;
    }
    
    /**
     * @param breederCd 生産者コード
     */
    public void setBreederCd(java.lang.String breederCd) {
        this.breederCd = breederCd;
    }    
    
    /**
     * @return 産地名
     */
    public java.lang.String getSourceName() {
        return sourceName;
    }
    
    /**
     * @param sourceName 産地名
     */
    public void setSourceName(java.lang.String sourceName) {
        this.sourceName = sourceName;
    }    
    
    /**
     * @return 3代血統 繁殖登録番号
     */
    public java.util.List<java.lang.String> getBreedingRegistNoItems() {
        return breedingRegistNoItems;
    }
    
    /**
     * @param breedingRegistNoItems 3代血統 繁殖登録番号
     */
    public void setBreedingRegistNoItems(java.util.List<java.lang.String> breedingRegistNoItems) {
        this.breedingRegistNoItems = breedingRegistNoItems;
    }      
    
}