/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.dto;
 
 /**
 * レコードフォーマットID {@link org.stormcat.jvbeans.config.RecordTypeId.H1} に対応するDtoです。
 * @author jv-beans-gen
 *
 */
@org.stormcat.jvbeans.annotation.JvBean(recordTypeId = org.stormcat.jvbeans.config.RecordTypeId.H1, byteLength = 28955)
public class VoteCount1Dto extends org.stormcat.jvbeans.jvlink.JvBindingDto {

    /** レコード種別ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1, byteLength = 2)
    private org.stormcat.jvbeans.config.RecordTypeId recordTypeId;

    /** データ区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 3, byteLength = 1)
    private java.lang.String dataDiv;

    /** データ作成年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4, byteLength = 8)
    private java.util.Date dataCreateDate;

    /** 開催年 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12, byteLength = 4)
    private java.lang.Integer holdingYear;

    /** 開催月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 16, byteLength = 4)
    private java.lang.String holdingDate;

    /** 競馬場コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 20, byteLength = 2)
    private org.stormcat.jvbeans.config.code.CourseCd courseCd;

    /** 開催回[第N回] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 22, byteLength = 2)
    private java.lang.Integer holdingNo;

    /** 開催日目[N日目] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 24, byteLength = 2)
    private java.lang.Integer holdingDay;

    /** レース番号 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 26, byteLength = 2)
    private java.lang.Integer raceNo;

    /** 登録頭数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28, byteLength = 2)
    private java.lang.Integer entryCount;

    /** 出走頭数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 30, byteLength = 2)
    private java.lang.Integer starterCount;

    /** 発売フラグ　単勝 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 32, byteLength = 1)
    private java.lang.Integer saleFlgWin;

    /** 発売フラグ　複勝 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 33, byteLength = 1)
    private java.lang.Integer saleFlgShow;

    /** 発売フラグ　枠連 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 34, byteLength = 1)
    private java.lang.Integer saleFlgBracket;

    /** 発売フラグ　馬連 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 35, byteLength = 1)
    private java.lang.Integer saleFlgQuinella;

    /** 発売フラグ　ワイド */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 36, byteLength = 1)
    private java.lang.Integer saleFlgQuinellaPlace;

    /** 発売フラグ　馬単 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 37, byteLength = 1)
    private java.lang.Integer saleFlgExacta;

    /** 発売フラグ　3連複 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 38, byteLength = 1)
    private java.lang.Integer saleFlgTrio;

    /** 複勝着払キー */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 39, byteLength = 1)
    private java.lang.Integer showCashKey;

    /** 返還馬番情報(馬番01～28) */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 40, byteLength = 1, repeatCount = 28)
    private java.util.List<java.lang.Integer> restoreHorseNoItems;

    /** 返還枠番情報(枠番1～8) */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 68, byteLength = 1, repeatCount = 8)
    private java.util.List<java.lang.Integer> restoreBracketItems;

    /** 返還同枠情報(枠番1～8) */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 76, byteLength = 1, repeatCount = 8)
    private java.util.List<java.lang.Integer> restoreSameBracketItems;

    /** 単勝票数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 84, byteLength = 15, repeatCount = 28)
    private java.util.List<org.stormcat.jvbeans.dto.child.VoteCountWinDto> voteCountWinItems;

    /** 複勝票数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 504, byteLength = 15, repeatCount = 28)
    private java.util.List<org.stormcat.jvbeans.dto.child.VoteCountShowDto> voteCountShowItems;

    /** 枠連票数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 924, byteLength = 15, repeatCount = 36)
    private java.util.List<org.stormcat.jvbeans.dto.child.VoteCountBracketDto> voteCountBracketItems;

    /** 馬連票数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1464, byteLength = 18, repeatCount = 153)
    private java.util.List<org.stormcat.jvbeans.dto.child.VoteCountQuinellaDto> voteCountQuinellaItems;

    /** ワイド票数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4218, byteLength = 18, repeatCount = 153)
    private java.util.List<org.stormcat.jvbeans.dto.child.VoteCountQuinellaPlaceDto> voteCountQuinellaPlaceItems;

    /** 馬単票数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 6972, byteLength = 18, repeatCount = 306)
    private java.util.List<org.stormcat.jvbeans.dto.child.VoteCountExactaDto> voteCountExactaItems;

    /** 3連複票数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12480, byteLength = 20, repeatCount = 816)
    private java.util.List<org.stormcat.jvbeans.dto.child.VoteCountTrioDto> voteCountTrioItems;

    /** 単勝票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28800, byteLength = 11)
    private java.lang.String voteCountTotalWin;

    /** 複勝票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28811, byteLength = 11)
    private java.lang.String voteCountTotalShow;

    /** 枠連票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28822, byteLength = 11)
    private java.lang.String voteCountTotalBracket;

    /** 馬連票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28833, byteLength = 11)
    private java.lang.String voteCountTotalQuinella;

    /** ワイド票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28844, byteLength = 11)
    private java.lang.String voteCountTotalQuinellaPlace;

    /** 馬単票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28855, byteLength = 11)
    private java.lang.String voteCountTotalExacta;

    /** 3連複票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28866, byteLength = 11)
    private java.lang.String voteCountTotalTrio;

    /** 単勝返還票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28877, byteLength = 11)
    private java.lang.String restoreVoteCountTotalWin;

    /** 複勝返還票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28888, byteLength = 11)
    private java.lang.String restoreVoteCountTotalShow;

    /** 枠連返還票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28899, byteLength = 11)
    private java.lang.String restoreVoteCountTotalBracket;

    /** 馬連返還票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28910, byteLength = 11)
    private java.lang.String restoreVoteCountTotalQuinella;

    /** ワイド返還票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28921, byteLength = 11)
    private java.lang.String restoreVoteCountTotalQuinellaPlace;

    /** 馬単返還票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28932, byteLength = 11)
    private java.lang.String restoreVoteCountTotalExacta;

    /** 3連複返還票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28943, byteLength = 11)
    private java.lang.String restoreVoteCountTotalTrio;


    /**
     * @return レコード種別ID
     */
    public org.stormcat.jvbeans.config.RecordTypeId getRecordTypeId() {
        return recordTypeId;
    }
    
    /**
     * @param recordTypeId レコード種別ID
     */
    public void setRecordTypeId(org.stormcat.jvbeans.config.RecordTypeId recordTypeId) {
        this.recordTypeId = recordTypeId;
    }    
    
    /**
     * @return データ区分
     */
    public java.lang.String getDataDiv() {
        return dataDiv;
    }
    
    /**
     * @param dataDiv データ区分
     */
    public void setDataDiv(java.lang.String dataDiv) {
        this.dataDiv = dataDiv;
    }    
    
    /**
     * @return データ作成年月日
     */
    public java.util.Date getDataCreateDate() {
        return dataCreateDate;
    }
    
    /**
     * @param dataCreateDate データ作成年月日
     */
    public void setDataCreateDate(java.util.Date dataCreateDate) {
        this.dataCreateDate = dataCreateDate;
    }    
    
    /**
     * @return 開催年
     */
    public java.lang.Integer getHoldingYear() {
        return holdingYear;
    }
    
    /**
     * @param holdingYear 開催年
     */
    public void setHoldingYear(java.lang.Integer holdingYear) {
        this.holdingYear = holdingYear;
    }    
    
    /**
     * @return 開催月日
     */
    public java.lang.String getHoldingDate() {
        return holdingDate;
    }
    
    /**
     * @param holdingDate 開催月日
     */
    public void setHoldingDate(java.lang.String holdingDate) {
        this.holdingDate = holdingDate;
    }    
    
    /**
     * @return 競馬場コード
     */
    public org.stormcat.jvbeans.config.code.CourseCd getCourseCd() {
        return courseCd;
    }
    
    /**
     * @param courseCd 競馬場コード
     */
    public void setCourseCd(org.stormcat.jvbeans.config.code.CourseCd courseCd) {
        this.courseCd = courseCd;
    }    
    
    /**
     * @return 開催回[第N回]
     */
    public java.lang.Integer getHoldingNo() {
        return holdingNo;
    }
    
    /**
     * @param holdingNo 開催回[第N回]
     */
    public void setHoldingNo(java.lang.Integer holdingNo) {
        this.holdingNo = holdingNo;
    }    
    
    /**
     * @return 開催日目[N日目]
     */
    public java.lang.Integer getHoldingDay() {
        return holdingDay;
    }
    
    /**
     * @param holdingDay 開催日目[N日目]
     */
    public void setHoldingDay(java.lang.Integer holdingDay) {
        this.holdingDay = holdingDay;
    }    
    
    /**
     * @return レース番号
     */
    public java.lang.Integer getRaceNo() {
        return raceNo;
    }
    
    /**
     * @param raceNo レース番号
     */
    public void setRaceNo(java.lang.Integer raceNo) {
        this.raceNo = raceNo;
    }    
    
    /**
     * @return 登録頭数
     */
    public java.lang.Integer getEntryCount() {
        return entryCount;
    }
    
    /**
     * @param entryCount 登録頭数
     */
    public void setEntryCount(java.lang.Integer entryCount) {
        this.entryCount = entryCount;
    }    
    
    /**
     * @return 出走頭数
     */
    public java.lang.Integer getStarterCount() {
        return starterCount;
    }
    
    /**
     * @param starterCount 出走頭数
     */
    public void setStarterCount(java.lang.Integer starterCount) {
        this.starterCount = starterCount;
    }    
    
    /**
     * @return 発売フラグ　単勝
     */
    public java.lang.Integer getSaleFlgWin() {
        return saleFlgWin;
    }
    
    /**
     * @param saleFlgWin 発売フラグ　単勝
     */
    public void setSaleFlgWin(java.lang.Integer saleFlgWin) {
        this.saleFlgWin = saleFlgWin;
    }    
    
    /**
     * @return 発売フラグ　複勝
     */
    public java.lang.Integer getSaleFlgShow() {
        return saleFlgShow;
    }
    
    /**
     * @param saleFlgShow 発売フラグ　複勝
     */
    public void setSaleFlgShow(java.lang.Integer saleFlgShow) {
        this.saleFlgShow = saleFlgShow;
    }    
    
    /**
     * @return 発売フラグ　枠連
     */
    public java.lang.Integer getSaleFlgBracket() {
        return saleFlgBracket;
    }
    
    /**
     * @param saleFlgBracket 発売フラグ　枠連
     */
    public void setSaleFlgBracket(java.lang.Integer saleFlgBracket) {
        this.saleFlgBracket = saleFlgBracket;
    }    
    
    /**
     * @return 発売フラグ　馬連
     */
    public java.lang.Integer getSaleFlgQuinella() {
        return saleFlgQuinella;
    }
    
    /**
     * @param saleFlgQuinella 発売フラグ　馬連
     */
    public void setSaleFlgQuinella(java.lang.Integer saleFlgQuinella) {
        this.saleFlgQuinella = saleFlgQuinella;
    }    
    
    /**
     * @return 発売フラグ　ワイド
     */
    public java.lang.Integer getSaleFlgQuinellaPlace() {
        return saleFlgQuinellaPlace;
    }
    
    /**
     * @param saleFlgQuinellaPlace 発売フラグ　ワイド
     */
    public void setSaleFlgQuinellaPlace(java.lang.Integer saleFlgQuinellaPlace) {
        this.saleFlgQuinellaPlace = saleFlgQuinellaPlace;
    }    
    
    /**
     * @return 発売フラグ　馬単
     */
    public java.lang.Integer getSaleFlgExacta() {
        return saleFlgExacta;
    }
    
    /**
     * @param saleFlgExacta 発売フラグ　馬単
     */
    public void setSaleFlgExacta(java.lang.Integer saleFlgExacta) {
        this.saleFlgExacta = saleFlgExacta;
    }    
    
    /**
     * @return 発売フラグ　3連複
     */
    public java.lang.Integer getSaleFlgTrio() {
        return saleFlgTrio;
    }
    
    /**
     * @param saleFlgTrio 発売フラグ　3連複
     */
    public void setSaleFlgTrio(java.lang.Integer saleFlgTrio) {
        this.saleFlgTrio = saleFlgTrio;
    }    
    
    /**
     * @return 複勝着払キー
     */
    public java.lang.Integer getShowCashKey() {
        return showCashKey;
    }
    
    /**
     * @param showCashKey 複勝着払キー
     */
    public void setShowCashKey(java.lang.Integer showCashKey) {
        this.showCashKey = showCashKey;
    }    
    
    /**
     * @return 返還馬番情報(馬番01～28)
     */
    public java.util.List<java.lang.Integer> getRestoreHorseNoItems() {
        return restoreHorseNoItems;
    }
    
    /**
     * @param restoreHorseNoItems 返還馬番情報(馬番01～28)
     */
    public void setRestoreHorseNoItems(java.util.List<java.lang.Integer> restoreHorseNoItems) {
        this.restoreHorseNoItems = restoreHorseNoItems;
    }      
    
    /**
     * @return 返還枠番情報(枠番1～8)
     */
    public java.util.List<java.lang.Integer> getRestoreBracketItems() {
        return restoreBracketItems;
    }
    
    /**
     * @param restoreBracketItems 返還枠番情報(枠番1～8)
     */
    public void setRestoreBracketItems(java.util.List<java.lang.Integer> restoreBracketItems) {
        this.restoreBracketItems = restoreBracketItems;
    }      
    
    /**
     * @return 返還同枠情報(枠番1～8)
     */
    public java.util.List<java.lang.Integer> getRestoreSameBracketItems() {
        return restoreSameBracketItems;
    }
    
    /**
     * @param restoreSameBracketItems 返還同枠情報(枠番1～8)
     */
    public void setRestoreSameBracketItems(java.util.List<java.lang.Integer> restoreSameBracketItems) {
        this.restoreSameBracketItems = restoreSameBracketItems;
    }      
    
    /**
     * @return 単勝票数
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.VoteCountWinDto> getVoteCountWinItems() {
        return voteCountWinItems;
    }
    
    /**
     * @param voteCountWinItems 単勝票数
     */
    public void setVoteCountWinItems(java.util.List<org.stormcat.jvbeans.dto.child.VoteCountWinDto> voteCountWinItems) {
        this.voteCountWinItems = voteCountWinItems;
    }      
    
    /**
     * @return 複勝票数
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.VoteCountShowDto> getVoteCountShowItems() {
        return voteCountShowItems;
    }
    
    /**
     * @param voteCountShowItems 複勝票数
     */
    public void setVoteCountShowItems(java.util.List<org.stormcat.jvbeans.dto.child.VoteCountShowDto> voteCountShowItems) {
        this.voteCountShowItems = voteCountShowItems;
    }      
    
    /**
     * @return 枠連票数
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.VoteCountBracketDto> getVoteCountBracketItems() {
        return voteCountBracketItems;
    }
    
    /**
     * @param voteCountBracketItems 枠連票数
     */
    public void setVoteCountBracketItems(java.util.List<org.stormcat.jvbeans.dto.child.VoteCountBracketDto> voteCountBracketItems) {
        this.voteCountBracketItems = voteCountBracketItems;
    }      
    
    /**
     * @return 馬連票数
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.VoteCountQuinellaDto> getVoteCountQuinellaItems() {
        return voteCountQuinellaItems;
    }
    
    /**
     * @param voteCountQuinellaItems 馬連票数
     */
    public void setVoteCountQuinellaItems(java.util.List<org.stormcat.jvbeans.dto.child.VoteCountQuinellaDto> voteCountQuinellaItems) {
        this.voteCountQuinellaItems = voteCountQuinellaItems;
    }      
    
    /**
     * @return ワイド票数
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.VoteCountQuinellaPlaceDto> getVoteCountQuinellaPlaceItems() {
        return voteCountQuinellaPlaceItems;
    }
    
    /**
     * @param voteCountQuinellaPlaceItems ワイド票数
     */
    public void setVoteCountQuinellaPlaceItems(java.util.List<org.stormcat.jvbeans.dto.child.VoteCountQuinellaPlaceDto> voteCountQuinellaPlaceItems) {
        this.voteCountQuinellaPlaceItems = voteCountQuinellaPlaceItems;
    }      
    
    /**
     * @return 馬単票数
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.VoteCountExactaDto> getVoteCountExactaItems() {
        return voteCountExactaItems;
    }
    
    /**
     * @param voteCountExactaItems 馬単票数
     */
    public void setVoteCountExactaItems(java.util.List<org.stormcat.jvbeans.dto.child.VoteCountExactaDto> voteCountExactaItems) {
        this.voteCountExactaItems = voteCountExactaItems;
    }      
    
    /**
     * @return 3連複票数
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.VoteCountTrioDto> getVoteCountTrioItems() {
        return voteCountTrioItems;
    }
    
    /**
     * @param voteCountTrioItems 3連複票数
     */
    public void setVoteCountTrioItems(java.util.List<org.stormcat.jvbeans.dto.child.VoteCountTrioDto> voteCountTrioItems) {
        this.voteCountTrioItems = voteCountTrioItems;
    }      
    
    /**
     * @return 単勝票数合計
     */
    public java.lang.String getVoteCountTotalWin() {
        return voteCountTotalWin;
    }
    
    /**
     * @param voteCountTotalWin 単勝票数合計
     */
    public void setVoteCountTotalWin(java.lang.String voteCountTotalWin) {
        this.voteCountTotalWin = voteCountTotalWin;
    }    
    
    /**
     * @return 複勝票数合計
     */
    public java.lang.String getVoteCountTotalShow() {
        return voteCountTotalShow;
    }
    
    /**
     * @param voteCountTotalShow 複勝票数合計
     */
    public void setVoteCountTotalShow(java.lang.String voteCountTotalShow) {
        this.voteCountTotalShow = voteCountTotalShow;
    }    
    
    /**
     * @return 枠連票数合計
     */
    public java.lang.String getVoteCountTotalBracket() {
        return voteCountTotalBracket;
    }
    
    /**
     * @param voteCountTotalBracket 枠連票数合計
     */
    public void setVoteCountTotalBracket(java.lang.String voteCountTotalBracket) {
        this.voteCountTotalBracket = voteCountTotalBracket;
    }    
    
    /**
     * @return 馬連票数合計
     */
    public java.lang.String getVoteCountTotalQuinella() {
        return voteCountTotalQuinella;
    }
    
    /**
     * @param voteCountTotalQuinella 馬連票数合計
     */
    public void setVoteCountTotalQuinella(java.lang.String voteCountTotalQuinella) {
        this.voteCountTotalQuinella = voteCountTotalQuinella;
    }    
    
    /**
     * @return ワイド票数合計
     */
    public java.lang.String getVoteCountTotalQuinellaPlace() {
        return voteCountTotalQuinellaPlace;
    }
    
    /**
     * @param voteCountTotalQuinellaPlace ワイド票数合計
     */
    public void setVoteCountTotalQuinellaPlace(java.lang.String voteCountTotalQuinellaPlace) {
        this.voteCountTotalQuinellaPlace = voteCountTotalQuinellaPlace;
    }    
    
    /**
     * @return 馬単票数合計
     */
    public java.lang.String getVoteCountTotalExacta() {
        return voteCountTotalExacta;
    }
    
    /**
     * @param voteCountTotalExacta 馬単票数合計
     */
    public void setVoteCountTotalExacta(java.lang.String voteCountTotalExacta) {
        this.voteCountTotalExacta = voteCountTotalExacta;
    }    
    
    /**
     * @return 3連複票数合計
     */
    public java.lang.String getVoteCountTotalTrio() {
        return voteCountTotalTrio;
    }
    
    /**
     * @param voteCountTotalTrio 3連複票数合計
     */
    public void setVoteCountTotalTrio(java.lang.String voteCountTotalTrio) {
        this.voteCountTotalTrio = voteCountTotalTrio;
    }    
    
    /**
     * @return 単勝返還票数合計
     */
    public java.lang.String getRestoreVoteCountTotalWin() {
        return restoreVoteCountTotalWin;
    }
    
    /**
     * @param restoreVoteCountTotalWin 単勝返還票数合計
     */
    public void setRestoreVoteCountTotalWin(java.lang.String restoreVoteCountTotalWin) {
        this.restoreVoteCountTotalWin = restoreVoteCountTotalWin;
    }    
    
    /**
     * @return 複勝返還票数合計
     */
    public java.lang.String getRestoreVoteCountTotalShow() {
        return restoreVoteCountTotalShow;
    }
    
    /**
     * @param restoreVoteCountTotalShow 複勝返還票数合計
     */
    public void setRestoreVoteCountTotalShow(java.lang.String restoreVoteCountTotalShow) {
        this.restoreVoteCountTotalShow = restoreVoteCountTotalShow;
    }    
    
    /**
     * @return 枠連返還票数合計
     */
    public java.lang.String getRestoreVoteCountTotalBracket() {
        return restoreVoteCountTotalBracket;
    }
    
    /**
     * @param restoreVoteCountTotalBracket 枠連返還票数合計
     */
    public void setRestoreVoteCountTotalBracket(java.lang.String restoreVoteCountTotalBracket) {
        this.restoreVoteCountTotalBracket = restoreVoteCountTotalBracket;
    }    
    
    /**
     * @return 馬連返還票数合計
     */
    public java.lang.String getRestoreVoteCountTotalQuinella() {
        return restoreVoteCountTotalQuinella;
    }
    
    /**
     * @param restoreVoteCountTotalQuinella 馬連返還票数合計
     */
    public void setRestoreVoteCountTotalQuinella(java.lang.String restoreVoteCountTotalQuinella) {
        this.restoreVoteCountTotalQuinella = restoreVoteCountTotalQuinella;
    }    
    
    /**
     * @return ワイド返還票数合計
     */
    public java.lang.String getRestoreVoteCountTotalQuinellaPlace() {
        return restoreVoteCountTotalQuinellaPlace;
    }
    
    /**
     * @param restoreVoteCountTotalQuinellaPlace ワイド返還票数合計
     */
    public void setRestoreVoteCountTotalQuinellaPlace(java.lang.String restoreVoteCountTotalQuinellaPlace) {
        this.restoreVoteCountTotalQuinellaPlace = restoreVoteCountTotalQuinellaPlace;
    }    
    
    /**
     * @return 馬単返還票数合計
     */
    public java.lang.String getRestoreVoteCountTotalExacta() {
        return restoreVoteCountTotalExacta;
    }
    
    /**
     * @param restoreVoteCountTotalExacta 馬単返還票数合計
     */
    public void setRestoreVoteCountTotalExacta(java.lang.String restoreVoteCountTotalExacta) {
        this.restoreVoteCountTotalExacta = restoreVoteCountTotalExacta;
    }    
    
    /**
     * @return 3連複返還票数合計
     */
    public java.lang.String getRestoreVoteCountTotalTrio() {
        return restoreVoteCountTotalTrio;
    }
    
    /**
     * @param restoreVoteCountTotalTrio 3連複返還票数合計
     */
    public void setRestoreVoteCountTotalTrio(java.lang.String restoreVoteCountTotalTrio) {
        this.restoreVoteCountTotalTrio = restoreVoteCountTotalTrio;
    }    
    
}