/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.resolver;

import org.stormcat.jvbeans.config.dataspec._0b11;
import org.stormcat.jvbeans.config.dataspec._0b12;
import org.stormcat.jvbeans.config.dataspec._0b13;
import org.stormcat.jvbeans.config.dataspec._0b14;
import org.stormcat.jvbeans.config.dataspec._0b15;
import org.stormcat.jvbeans.config.dataspec._0b20;
import org.stormcat.jvbeans.config.dataspec._0b30;
import org.stormcat.jvbeans.config.dataspec._0b31;
import org.stormcat.jvbeans.config.dataspec._0b32;
import org.stormcat.jvbeans.config.dataspec._0b33;
import org.stormcat.jvbeans.config.dataspec._0b34;
import org.stormcat.jvbeans.config.dataspec._0b35;
import org.stormcat.jvbeans.config.dataspec._0b36;
import org.stormcat.jvbeans.config.dataspec._0b41;
import org.stormcat.jvbeans.config.dataspec._0b42;

/**
 * 速報系データ取得条件を生成するためのリゾルバです。
 * @author a.yamada
 *
 */
public class RealTimeDataResolver {

    private RealTimeDataResolver() {
        throw new AssertionError();
    }
    
    /**
     * {@code 0B12}を返します。
     * @return {@code 0B12}
     */
    public static _0b12 _0B12() {
        return _0b12.INSTANCE;
    }
    
    /**
     * {@code 0B15}を返します。
     * @return {@code 0B15}
     */
    public static _0b15 _0B15() {
        return _0b15.INSTANCE;
    }
    
    /**
     * {@code 0B30}を返します。
     * @return {@code 0B30}
     */
    public static _0b30 _0B30() {
        return _0b30.INSTANCE;
    }
    
    /**
     * {@code 0B31}を返します。
     * @return {@code 0B31}
     */
    public static _0b31 _0B31() {
        return _0b31.INSTANCE;
    }
    
    /**
     * {@code 0B32}を返します。
     * @return {@code 0B32}
     */
    public static _0b32 _0B32() {
        return _0b32.INSTANCE;
    }
    
    /**
     * {@code 0B33}を返します。
     * @return {@code 0B33}
     */
    public static _0b33 _0B33() {
        return _0b33.INSTANCE;
    }
    
    /**
     * {@code 0B34}を返します。
     * @return {@code 0B34}
     */
    public static _0b34 _0B34() {
        return _0b34.INSTANCE;
    }
    
    /**
     * {@code 0B35}を返します。
     * @return {@code 0B35}
     */
    public static _0b35 _0B35() {
        return _0b35.INSTANCE;
    }
    
    /**
     * {@code 0B36}を返します。
     * @return {@code 0B36}
     */
    public static _0b36 _0B36() {
        return _0b36.INSTANCE;
    }
    
    /**
     * {@code 0B20}を返します。
     * @return {@code 0B20}
     */
    public static _0b20 _0B20() {
        return _0b20.INSTANCE;
    }
    
    /**
     * {@code 0B11}を返します。
     * @return {@code 0B11}
     */
    public static _0b11 _0B11() {
        return _0b11.INSTANCE;
    }
    
    /**
     * {@code 0B14}を返します。
     * @return {@code 0B14}
     */
    public static _0b14 _0B14() {
        return _0b14.INSTANCE;
    }
    
    /**
     * {@code 0B13}を返します。
     * @return {@code 0B13}
     */
    public static _0b13 _0B13() {
        return _0b13.INSTANCE;
    }
    
    /**
     * {@code 0B41}を返します。
     * @return {@code 0B41}
     */
    public static _0b41 _0B41() {
        return _0b41.INSTANCE;
    }
    
    /**
     * {@code 0B42}を返します。
     * @return {@code 0B42}
     */
    public static _0b42 _0B42() {
        return _0b42.INSTANCE;
    }
    
}
