/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.resolver;

import org.stormcat.jvbeans.config.dataspec._Blod;
import org.stormcat.jvbeans.config.dataspec._Comm;
import org.stormcat.jvbeans.config.dataspec._Hose;
import org.stormcat.jvbeans.config.dataspec._Hoyu;
import org.stormcat.jvbeans.config.dataspec._Race;
import org.stormcat.jvbeans.config.dataspec._SetupDiff;
import org.stormcat.jvbeans.config.dataspec._Slop;
import org.stormcat.jvbeans.config.dataspec._Snap;
import org.stormcat.jvbeans.config.dataspec._Ysch;

/**
 * セットアップデータのデータ取得条件を生成するためのリゾルバです。
 * @author a.yamada
 *
 */
public class SetupDataResolver {

    private SetupDataResolver() {
        throw new AssertionError();
    }
    
    /**
     * {@code RACE}を返します。
     * @return {@code RACE}
     */
    public static _Race _RACE() {
        return _Race.INSTANCE;
    }

    /**
     * {@code DIFF}を返します。
     * @return {@code DIFF}
     */
    public static _SetupDiff _DIFF() {
        return _SetupDiff.INSTANCE;
    }
    
    /**
     * {@code BLOD}を返します。
     * @return {@code BLOD}
     */
    public static _Blod _BLOD() {
        return _Blod.INSTANCE;
    }
    
    /**
     * {@code SNAP}を返します。
     * @return {@code SNAP}
     */
    public static _Snap _SNAP() {
        return _Snap.INSTANCE;
    }
    
    /**
     * {@code SLOP}を返します。
     * @return {@code SLOP}
     */
    public static _Slop _SLOP() {
        return  _Slop.INSTANCE;
    }
    
    /**
     * {@code YSCH}を返します。
     * @return {@code YSCH}
     */
    public static _Ysch _YSCH() {
        return _Ysch.INSTANCE;
    }
    
    /**
     * {@code HOSE}を返します。
     * @return {@code HOSE}
     */
    public static _Hose _HOSE() {
        return _Hose.INSTANCE;
    }
    
    /**
     * {@code HOYU}を返します。
     * @return {@code HOYU}
     */
    public static _Hoyu _HOYU() {
        return _Hoyu.INSTANCE;
    }
    
    /**
     * {@code COMM}を返します。
     * @return {@code COMM}
     */
    public static _Comm _COMM() {
        return _Comm.INSTANCE;
    }
    
}
