/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink.analyze;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stormcat.commons.reflect.ClassUtil;
import org.stormcat.commons.reflect.PackageUtil;
import org.stormcat.commons.resource.PathUtil;
import org.stormcat.commons.resource.ResourceUtil;
import org.stormcat.jvbeans.annotation.JvBean;
import org.stormcat.jvbeans.config.RecordTypeId;
import org.stormcat.jvbeans.exception.JvBeansRuntimeException;
import org.stormcat.jvbeans.jvlink.analyze.JvBeanMeta;
import org.stormcat.jvbeans.jvlink.analyze.JvRecordMeta;
import org.stormcat.jvbeans.jvlink.analyze.JvRecordMetaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvBeansContainer {
    private static Logger logger = LoggerFactory.getLogger(JvBeansContainer.class);
    private Map<String, JvBeanMeta> metaMap = new ConcurrentHashMap<String, JvBeanMeta>();
    private static final String RECORD_TYPE_ID_CLASS = "org.stormcat.jvbeans.jvlink.definitions.ConcreteRecordTypeId";
    private Class<? extends RecordTypeId> recordTypeIdClass = ClassUtil.forName((String)"org.stormcat.jvbeans.jvlink.definitions.ConcreteRecordTypeId");

    public void init(String dtoPackage) {
        logger.debug("JVBeansContainer\u3092\u521d\u671f\u5316\u3057\u307e\u3059\u30fb\u30fb\u30fb\u3002");
        URL url = Thread.currentThread().getContextClassLoader().getResource(ResourceUtil.getPath((Class)ClassUtil.forName((String)RECORD_TYPE_ID_CLASS)));
        logger.debug(String.format("\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u8d70\u67fb\u5bfe\u8c61\u306f\u30d1\u30c3\u30b1\u30fc\u30b8 %s \u306b\u6240\u5c5e\u3059\u308b\u30af\u30e9\u30b9\u3067\u3059\u3002", dtoPackage));
        List classList = null;
        if ("jar".equals(url.getProtocol())) {
            logger.debug("\u30af\u30e9\u30b9\u30d1\u30b9\u306b\u901a\u3063\u3066\u3044\u308bJar\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u8d70\u67fb\u3092\u884c\u3044\u307e\u3059\u3002");
            try {
                JarFile jarFile = new JarFile(PathUtil.getJarFilePath((URL)url));
                classList = PackageUtil.getClassList((JarFile)jarFile, (String)dtoPackage);
            }
            catch (IOException e) {
                throw new JvBeansRuntimeException(e);
            }
        } else {
            logger.debug("\u30af\u30e9\u30b9\u30d1\u30b9\u306b\u901a\u3063\u3066\u3044\u308b\u30d5\u30a1\u30a4\u30eb\u30b7\u30b9\u30c6\u30e0\u304b\u3089\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u8d70\u67fb\u3092\u884c\u3044\u307e\u3059\u3002");
            classList = PackageUtil.getClassList((String)dtoPackage);
        }
        logger.debug("\u30af\u30e9\u30b9\u8d70\u67fb\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002\u30e1\u30bf\u60c5\u5831\u3092\u7d44\u307f\u7acb\u3066\u307e\u3059\u30fb\u30fb\u30fb");
        JvRecordMetaFactory metaFactory = new JvRecordMetaFactory(this.getRecordTypeIdClass());
        for (Class c : classList) {
            JvBean jvBean = c.getAnnotation(JvBean.class);
            if (jvBean == null) continue;
            ArrayList<JvRecordMeta> metaItems = new ArrayList<JvRecordMeta>();
            Field[] fieldArray = c.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                metaItems.add(metaFactory.create(field));
                ++n2;
            }
            this.metaMap.put(jvBean.recordTypeId(), new JvBeanMeta(c, metaItems));
            logger.debug(String.format("%s \u306e\u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0\u60c5\u5831\u3092\u53d6\u5f97\u3057\u307e\u3057\u305f\u3002", c.getName()));
        }
    }

    public Class<?> getMappedType(RecordTypeId recordTypeId) {
        if (recordTypeId == null) {
            throw new IllegalArgumentException("\u30ec\u30b3\u30fc\u30c9\u7a2e\u5225ID\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        return this.metaMap.get(recordTypeId.getValue()).getType();
    }

    public int getRecordByteLength(RecordTypeId recordTypeId) {
        if (recordTypeId == null) {
            throw new IllegalArgumentException("\u30ec\u30b3\u30fc\u30c9\u7a2e\u5225ID\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        return this.metaMap.get(recordTypeId.getValue()).getByteLength();
    }

    public List<JvRecordMeta> getRecordMetaItems(String recordTypeId) {
        return this.metaMap.get(recordTypeId).getRecordMetaItems();
    }

    public Class<? extends RecordTypeId> getRecordTypeIdClass() {
        return this.recordTypeIdClass;
    }
}

