/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink.analyze;

import org.stormcat.commons.constants.FileExtension;
import org.stormcat.commons.lang.EnumUtil;
import org.stormcat.commons.lang.StringUtil;
import org.stormcat.commons.reflect.ClassUtil;
import org.stormcat.jvbeans.config.RecordTypeId;
import org.stormcat.jvbeans.config.condition.OpenCondition;
import org.stormcat.jvbeans.exception.JvBeansRuntimeException;
import org.stormcat.jvbeans.jvlink.JvBindingDto;
import org.stormcat.jvbeans.jvlink.analyze.JvBeansContainer;
import org.stormcat.jvbeans.jvlink.analyze.binder.JvDataBinder;
import org.stormcat.jvbeans.jvlink.analyze.binder.JvDataBinderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvBindingDtoFactory {
    private JvBeansContainer jvBeansContainer;
    private FileExtension inputType;

    public JvBindingDto create(String str) {
        if (StringUtil.isBlank((String)str)) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u304c\u7a7a\u3067\u3059");
        }
        RecordTypeId recordTypeId = (RecordTypeId)EnumUtil.getEnum(this.jvBeansContainer.getRecordTypeIdClass(), (String)str.substring(0, 2));
        if (recordTypeId == null) {
            throw new JvBeansRuntimeException("\u30ec\u30b3\u30fc\u30c9\u7a2e\u5225ID\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (this.jvBeansContainer == null) {
            throw new IllegalStateException("JVBindingDtoFactory\u306e\u30d7\u30ed\u30d1\u30c6\u30a3(jvBeansContainer)\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        JvBindingDto dto = (JvBindingDto)JvBindingDto.class.cast(ClassUtil.newInstance(this.jvBeansContainer.getMappedType(recordTypeId)));
        return this.createDto(str, recordTypeId, dto);
    }

    public <T extends JvBindingDto> T create(String str, OpenCondition<T> condition) {
        if (StringUtil.isBlank((String)str)) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u304c\u7a7a\u3067\u3059");
        }
        if (condition == null) {
            throw new JvBeansRuntimeException("\u30ec\u30b3\u30fc\u30c9\u7a2e\u5225ID\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (this.jvBeansContainer == null) {
            throw new IllegalStateException("JVBindingDtoFactory\u306e\u30d7\u30ed\u30d1\u30c6\u30a3(jvBeansContainer)\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        RecordTypeId recordTypeId = condition.getRecordTypeId();
        JvBindingDto dto = (JvBindingDto)ClassUtil.newInstance(condition.getType());
        return (T)this.createDto(str, recordTypeId, dto);
    }

    private <T extends JvBindingDto> T createDto(String str, RecordTypeId recordTypeId, T dto) {
        JvDataBinder binder = JvDataBinderFactory.createBinder(this.inputType);
        binder.bindProperty(this.jvBeansContainer.getRecordMetaItems(recordTypeId.toString()), dto, str);
        dto.setLine(str);
        return dto;
    }

    public void setJvBeansContainer(JvBeansContainer jvBeansContainer) {
        this.jvBeansContainer = jvBeansContainer;
    }

    public void setInputType(FileExtension inputType) {
        this.inputType = inputType;
    }
}

