#include "stdafx.h"

#include "EventLog.hpp"

#include <assert.h>

EventLog::EventLog( const std::string& v_eventSourceName )
	: eventSourceName_( v_eventSourceName )
	, hEventLog_( NULL )
{
	assert( ! v_eventSourceName.empty() && "Cxg\[XłB" );
}

EventLog::~EventLog() throw()
{
	close();
}

void EventLog::open()
{
	//required:
	assert( hEventLog_ == NULL && "łɃCxgO͊JĂ܂B" );
	
	//do:
	if( hEventLog_ == NULL ) {
		hEventLog_ = RegisterEventSource( NULL, eventSourceName_.c_str() );
		if( hEventLog_ == NULL ) {
			throw std::runtime_error( "CxgOJ܂B" );
		}
	}
}

void EventLog::close() throw()
{
	if( hEventLog_ != NULL ) {
		DeregisterEventSource( hEventLog_ );
		hEventLog_ = NULL;
	}
}

void EventLog::reportEvent( DWORD v_eventID, WORD cnt, LPCSTR* messages, WORD v_eventType ) const
{
	//required:
	assert( hEventLog_ != NULL && "CxgOJĂ܂B" );

	//do:
	if( hEventLog_ != NULL ) {
		ReportEvent(
			hEventLog_,
			v_eventType,
			0,
			v_eventID,
			NULL,
			cnt,
			0,
			(LPCTSTR*) messages,
			NULL
			);
	}
}

void EventLog::registerEventSource( HMODULE v_hModule )
{
	CHAR modulePath[ MAX_PATH + 1 ];
	modulePath[ GetModuleFileName( v_hModule, modulePath, MAX_PATH ) ] = 0;
	if( modulePath[ 0 ] ) {
		HKEY hKey = NULL;
		DWORD disp = 0;
		std::string regEntry("System\\CurrentControlSet\\Services\\EventLog\\Application\\");
		regEntry += eventSourceName_;
		if( ERROR_SUCCESS == RegCreateKeyEx(
				HKEY_LOCAL_MACHINE,
				regEntry.c_str(),
				0,
				NULL,
				REG_OPTION_NON_VOLATILE,
				KEY_ALL_ACCESS,
				NULL,
				&hKey,
				&disp
			) )
		{
			RegSetValueEx( hKey, "EventMessageFile", 0, REG_EXPAND_SZ, (LPBYTE) modulePath, (DWORD)(strlen( modulePath ) + 1 ) );
			DWORD typ = EVENTLOG_ERROR_TYPE | EVENTLOG_WARNING_TYPE | EVENTLOG_INFORMATION_TYPE;
			RegSetValueEx( hKey, "TypesSupported", 0, REG_DWORD, (LPBYTE) &typ, sizeof(DWORD) );
			RegCloseKey( hKey );
		}
	}
}
