#ifndef INCLUDE_H_JAVAVMMAINTHREAD
#define INCLUDE_H_JAVAVMMAINTHREAD

#include <string>
#include <vector>
#include <exception>

#include "JavaVMCallback.hpp"

class StartupInfo
{
public:
	typedef std::vector<std::string> StringVector;

	typedef StringVector::iterator iterator;
	typedef StringVector::const_iterator const_iterator;
	typedef StringVector::value_type value_type;
	typedef StringVector::size_type size_type;
	typedef StringVector::reference reference;
	typedef StringVector::const_reference const_reference;

	StartupInfo( const std::string v_mainClassName, const std::string v_mainMethodName, bool v_fork );
	StartupInfo( const StartupInfo& v_other ) throw();
	StartupInfo& operator=( const StartupInfo& v_other ) throw();
	~StartupInfo() throw();

	const std::string& getMainClassName() const throw();
	const std::string& getMainMethodName() const throw();

	bool isFork() const;

	StartupInfo::iterator begin() throw();
	StartupInfo::const_iterator begin() const throw();
	StartupInfo::iterator end() throw();
	StartupInfo::const_iterator end() const throw();
	StartupInfo::size_type size() const throw();

	bool push_back( const std::string& v_arg ) throw();

private:
	std::string mainClassName_;
	std::string mainMethodName_;
	StringVector args_;
	bool fork_;
};

class JavaVMStartupInfo
{
public:
	typedef std::vector<std::string> StringVector;

	typedef StringVector::iterator iterator;
	typedef StringVector::const_iterator const_iterator;
	typedef StringVector::value_type value_type;
	typedef StringVector::size_type size_type;
	typedef StringVector::reference reference;
	typedef StringVector::const_reference const_reference;

	JavaVMStartupInfo( const bool v_ignoreUnrecognized = true );
	JavaVMStartupInfo( const JavaVMStartupInfo& v_other ) throw();
	JavaVMStartupInfo& operator=( const JavaVMStartupInfo& v_other ) throw();
	~JavaVMStartupInfo() throw();

	bool isIgnoreUnrecognized() const throw();

	JavaVMStartupInfo::iterator begin() throw();
	JavaVMStartupInfo::const_iterator begin() const throw();
	JavaVMStartupInfo::iterator end() throw();
	JavaVMStartupInfo::const_iterator end() const throw();
	JavaVMStartupInfo::size_type size() const throw();
	
	bool push_back( const std::string& v_arg ) throw();

private:
	bool ignoreUnrecognized_;
	StringVector options_;
};

class JavaVMMainThread
{
public:
	JavaVMMainThread( const JavaVMCallback& v_callback, const JavaVMStartupInfo& v_jvmStartupInfo );
	~JavaVMMainThread() throw();

	/*!
	 * ݂̃XbhJavaVM쐬܂B
	 * JavaVM쐬łȂꍇ͗O܂B
	 * \exception std::exception O
	 */
	void start();

	/*!
	 * ݂̃XbhJavaVMׂ̂ẴXbh̏Iҋ@܂B
	 * JavaVMJnĂȂꍇ͗O܂B
	 * \exception std::exception O
	 */
	void join();

	/*!
	 * VXbh쐬A\bhĂяo܂B
	 * v_waittruȅꍇ̓XbhI܂Ő߂܂B
	 * łȂΊ҂ɐԂ܂B
	 * JavaVMJnĂȂꍇ͗O܂B
	 * \param v_startupInfo Np[^
	 * \param v_wait Xbh̏Iҋ@ꍇAtrue
	 * \exception std::exception O
	 */
	void invokeClassMethod( const StartupInfo& v_startupInfo, bool v_wait = false );

	/*!
	 * ݂̃XbhJavaVMɐڑASystem.exit()Ăяo܂B
	 * JavaVMJnĂȂꍇ͗O܂B
	 * \exception std::exception O
	 */
	void stopInterrupt();

protected:

	static std::string ConvertToJNIClassName( const std::string& v_className ) throw();
	static bool GetExceptionDescription( JNIEnv* env, std::string& v_description ) throw();

	static unsigned __stdcall invokeClassMethodProc( void* v_pData );

private:
	JavaVMCallback callback_;
	JavaVM* jvm_;

	JavaVMStartupInfo jvmStartupInfo_;
};

#endif
