#include "stdafx.h"

#include "EventLog.hpp"

#include <assert.h>

EventLog::EventLog( const std::string& v_eventSourceName ) throw()
	: eventSourceName_( v_eventSourceName )
	, hEventLog_( NULL )
{
	assert( ! v_eventSourceName.empty() && "Cxg\[XłB" );
}

EventLog::~EventLog() throw()
{
	close();
}

void EventLog::open() throw ( std::exception )
{
	//required:
	assert( hEventLog_ == NULL && "łɃCxgO͊JĂ܂B" );
	
	//do:
	if( hEventLog_ == NULL ) {
		hEventLog_ = RegisterEventSource( NULL, eventSourceName_.c_str() );
		Win32Exception::checkAndThrow( hEventLog_ != NULL );
	}
}

void EventLog::close() throw()
{
	if( hEventLog_ != NULL ) {
		DeregisterEventSource( hEventLog_ );
		hEventLog_ = NULL;
	}
}

void EventLog::reportEvent( DWORD v_eventID, WORD cnt, LPCSTR* messages, WORD v_eventType ) const throw()
{
	//required:
	assert( hEventLog_ != NULL && "CxgOJĂ܂B" );

	//do:
	if( hEventLog_ != NULL ) {
		ReportEvent(
			hEventLog_,
			v_eventType,
			0,
			v_eventID,
			NULL,
			cnt,
			0,
			(LPCTSTR*) messages,
			NULL
			);
	}
}

void EventLog::registerEventSource( const std::string& v_modulePath ) throw ( std::exception )
{
	//required:
	assert( ! v_modulePath.empty() );

	//do:

	std::string regEntry( "System\\CurrentControlSet\\Services\\EventLog\\Application\\" );
	regEntry += eventSourceName_;

	HKEY hKey = NULL;
	DWORD disp = 0;

	LONG ret;
	ret = RegCreateKeyEx(
		HKEY_LOCAL_MACHINE,
		regEntry.c_str(),
		0,
		NULL,
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hKey,
		&disp
        );
	Win32Exception::checkAndThrow( ret == ERROR_SUCCESS );

	try{
		ret = RegSetValueEx(
			hKey,
			"EventMessageFile",
			0,
			REG_EXPAND_SZ,
			(LPBYTE) v_modulePath.c_str(),
			(DWORD)( v_modulePath.size() + 1 )
			);
		Win32Exception::checkAndThrow( ret == ERROR_SUCCESS );

		DWORD typ = EVENTLOG_ERROR_TYPE | EVENTLOG_WARNING_TYPE | EVENTLOG_INFORMATION_TYPE;
		ret = RegSetValueEx(
			hKey,
			"TypesSupported",
			0,
			REG_DWORD,
			(LPBYTE) &typ,
			sizeof(DWORD)
			);
		Win32Exception::checkAndThrow( ret == ERROR_SUCCESS );
	}
	catch( ... ) {
		RegCloseKey( hKey );
		throw;
	}

	RegCloseKey( hKey );
}

void EventLog::unregisterEventSource( const std::string& v_modulePath ) throw ( std::exception )
{
	//required:
	assert( ! v_modulePath.empty() );

	//do:
	
	std::string regEntry( "System\\CurrentControlSet\\Services\\EventLog\\Application\\" );
	regEntry += eventSourceName_;

	LONG ret = RegDeleteKey( HKEY_LOCAL_MACHINE, regEntry.c_str() );
	Win32Exception::checkAndThrow( ret == ERROR_SUCCESS );
}

