#include "stdafx.h"

#include <assert.h>
#include <process.h>

#include <exception>
#include <fstream>

#include "ConfigParser.hpp"
#include "JavaVMMainThread.hpp"
#include "EventLog.hpp"

#include "JVMLauncher.hpp"

JVMLauncher::JVMLauncher( JVMEventListener& v_eventListener ) throw ()
	: eventListener_( v_eventListener )
{
}

void JVMLauncher::preloadLibrary( const std::string& v_preloadConfPath ) throw ( Win32Exception )
{
	if( v_preloadConfPath.empty() ) {
		return;
	}

	try{
		std::ifstream fin;
		fin.open( v_preloadConfPath.c_str() );
		if( ! fin.is_open() ) {
			return;
		}
		
		std::string line;
		while( getline( fin, line ) ) {
			CHAR dllPath[ MAX_PATH ];
			ExpandEnvironmentStrings( line.c_str(), dllPath, MAX_PATH );
			LPCSTR p = dllPath;
			while(*p) {
				if( *p == '#' || *p == ';' ) {
					break;
				}
				if( ! ( *p > 0 && *p <= ' ' ) ) {
					if( LoadLibrary( p ) == NULL ) {
						Win32Exception::throwWin32Exception( GetLastError() );
					}
					break;
				}
				p = CharNext( p );
			}
		}
		fin.close();
	}
	catch( const std::exception& v_exception ) {
		eventListener_.notifyLibraryLoadFailure( v_exception.what() );
		throw;
	}
	catch( ... ) {
		eventListener_.notifyLibraryLoadFailure( "sȗOɂ胉Cũ[hs܂B" );
		throw Win32Exception( "sȗOɂ胉Cũ[hs܂B", ERROR_FILE_NOT_FOUND );
	}
}

void JVMLauncher::launchJVM( const std::string& v_configPath ) throw( std::exception )
{
	try{
		if( pJVM_.get() != NULL ) {
			throw std::logic_error( "łJVM͊JnĂ܂B" );
		}

		ConfigParser parser;
		parser.parse( v_configPath );

		JavaVMMainThreadPtr pJVM( new JavaVMMainThread( eventListener_, parser.getJavaVMStartupInfo() ) );
		pJVM->start();
		pJVM_ = pJVM; // Jnł烍[JϐCX^XϐɈړ
		assert( pJVM.get() == NULL );

		eventListener_.notifyJVMStarted();

		const ConfigParser::size_type mx = parser.size();
		ConfigParser::size_type idx = 1;
		for( ConfigParser::const_iterator p=parser.begin(), last=parser.end();
			p != last;
			++p, ++idx)
		{
			const StartupInfo& startupInfo = *p;
			if( ! pJVM_->invokeClassMethod( startupInfo, ( idx == mx ) || ! startupInfo.isFork() ) ) {
				break;
			}
		}
	}
	catch( const std::exception& v_exception ) {
		eventListener_.notifyException( v_exception.what() );
		throw;
	}
	catch( ... ) {
		eventListener_.notifyException( "JVMLauncher#executeŕsȗO܂B" );
		throw std::runtime_error( "JVMLauncher#executeŕsȗO܂B" );
	}
}

unsigned __stdcall JVMLauncher::stopThreadProc( void* v_pData ) throw()
{
	JVMLauncher* me = reinterpret_cast<JVMLauncher*>( v_pData );
	assert( me != NULL );

	try{
		JavaVMMainThread& jvm = *me->pJVM_.get();
		jvm.stopInterrupt();
		return 0;
	}
	catch( const std::exception& v_exception ) {
		std::string mes( "JVM̒~vOɂ莸s܂B:" );
		mes += v_exception.what();
		me->eventListener_.notifyException( mes.c_str() );
	}
	catch( ... ) {
		me->eventListener_.notifyException( "JVM̒~vsȗOɂ莸s܂B" );
	}

	me->eventListener_.notifyJVMAborted();
	exit( 3 );
	return 0;
}

bool JVMLauncher::shutdown() throw()
{
	assert( pJVM_.get() != NULL );
	
	unsigned tid = 0;
	HANDLE hThread = (HANDLE) _beginthreadex( NULL, 0, stopThreadProc, this, 0, &tid );
	if( hThread != NULL ) {
		CloseHandle( hThread );
		return true;
	}
	eventListener_.notifyException( "JVM̒~vXbh쐬ł܂łB" );
	return false;
}

void JVMLauncher::switchToJVM() throw()
{
	assert( pJVM_.get() != NULL );

	JavaVMMainThread& jvm = *pJVM_.get();
	jvm.waitForFinishedAll();
}

