#include "stdafx.h"

#include "JavaVMStartupInfo.hpp"

JavaVMStartupInfo::JavaVMStartupInfo( const bool v_ignoreUnrecognized ) throw()
	: ignoreUnrecognized_( v_ignoreUnrecognized )
{
}

JavaVMStartupInfo::JavaVMStartupInfo( const JavaVMStartupInfo& v_other ) throw()
	: ignoreUnrecognized_( v_other.ignoreUnrecognized_ )
	, options_( v_other.options_ )
{
}

JavaVMStartupInfo& JavaVMStartupInfo::operator=( const JavaVMStartupInfo& v_other ) throw()
{
	if( this != &v_other ) {
		ignoreUnrecognized_ = v_other.ignoreUnrecognized_;
		options_ = v_other.options_;
	}
	return *this;
}

JavaVMStartupInfo::~JavaVMStartupInfo() throw()
{
}

bool JavaVMStartupInfo::isIgnoreUnrecognized() const throw()
{
	return ignoreUnrecognized_;
}

JavaVMStartupInfo::iterator JavaVMStartupInfo::begin() throw()
{
	return options_.begin();
}

JavaVMStartupInfo::const_iterator JavaVMStartupInfo::begin() const throw()
{
	return options_.begin();
}

JavaVMStartupInfo::iterator JavaVMStartupInfo::end() throw()
{
	return options_.end();
}

JavaVMStartupInfo::const_iterator JavaVMStartupInfo::end() const throw()
{
	return options_.end();
}

JavaVMStartupInfo::size_type JavaVMStartupInfo::size() const throw()
{
	return options_.size();
}

bool JavaVMStartupInfo::push_back( const std::string& v_arg ) throw()
{
	if( ! v_arg.empty() ) {
		options_.push_back( v_arg );
		return true;
	}
	return false;
}

