#include "stdafx.h"

#include "Win32Exception.hpp"

Win32Exception::Win32Exception( const char* v_message, DWORD v_errorCode )
	: std::exception( v_message )
	, errorCode_( v_errorCode )
{
}

DWORD Win32Exception::getErrorCode() const
{
	return errorCode_;
}

void Win32Exception::checkAndThrow( BOOL v_succeeded ) throw ( Win32Exception )
{
	if( v_succeeded ) {
		return;
	}
	throwWin32Exception( GetLastError() );
}

void Win32Exception::throwWin32Exception( DWORD v_errorCode ) throw ( Win32Exception )
{
	if( v_errorCode == ERROR_SUCCESS ) {
		return;
	}

	LPVOID lpMsgBuf = NULL;
	if( FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER |
		FORMAT_MESSAGE_FROM_SYSTEM |
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		v_errorCode,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // ̌
		(LPTSTR) &lpMsgBuf,
		0,
		NULL
		) != 0 )
	{
		std::string reason( (const char*) lpMsgBuf );
		LocalFree(lpMsgBuf);
		throw Win32Exception( reason.c_str(), v_errorCode );
	}
	else {
		throw Win32Exception( "sȗO܂B", v_errorCode );
	}
}

