#include "stdafx.h"

#include "service_main.hpp"

#include <stdio.h>
#include <direct.h>
#include <stdarg.h>
#include <assert.h>

#include "JavaVMCallback.hpp"
#include "JVMLauncher.hpp"
#include "EventLog.hpp"
#include "message.h"

namespace
{
	/*!
	 * T[rXXe[gnh
	 */
	SERVICE_STATUS serviceStatus = { 0 };

	/*!
	 * T[rXXe[g(ŐV̏Ԃێ܂)
	 */
	SERVICE_STATUS_HANDLE hServiceStatus = NULL;

	/*!
	 * CxgO
	 */
	EventLog* pEventLog_ = NULL;

	/*!
	 * JNIpݐ
	 */
	FILE* jvmLogFP_ = NULL;

	/*!
	 * JVM̃CxgXi
	 */
	class JVMEventListenerImpl* pEventListener_ = NULL;

	/*!
	 * T[rX
	 */
	CHAR szServiceName_[ MAX_PATH + 1 ];

	/*!
	 * ݒt@Cւ̃tpX
	 */
	CHAR szConfigPath_[ MAX_PATH + 1 ];

	/*!
	 * Ot@Cւ̃tpXA܂͋
	 */
	CHAR szLogPath_[ MAX_PATH + 1 ];

	/*!
	 * JVMX^[^ւ̃|C^
	 */
	JVMLauncher* pJVMLauncher_ = NULL;

	/*!
	 * IɃN[ibv̂߂ɌĂяo郋[`
	 */
	void cleanup();

	class JVMEventListenerImpl : public JVMEventListener
	{
	public:
		JVMEventListenerImpl( const std::string& v_serviceName, FILE* v_pJVMLog, EventLog& v_eventLog ) throw()
			: serviceName_( v_serviceName )
			, eventLog_( v_eventLog )
			, jvmLog_( v_pJVMLog )
		{
		}

		virtual ~JVMEventListenerImpl() throw()
		{
		}

		virtual void notifyJVMStarted() throw()
		{
			const char* mes[] = { serviceName_.c_str() };
			eventLog_.reportEvent(
				MSG_JAVAVM_STARTED,
				1,
				mes,
				EVENTLOG_INFORMATION_TYPE
				);
		}

		virtual void notifyJVMExited( int v_exitCode ) throw()
		{
			notifyJVMLog( "[jvmservice: JavaVMexit܂B:%d]\n", v_exitCode );
			CHAR buf[ 64 ];
			wsprintf( buf, "%d", v_exitCode );
			const char* mes[] = { buf, serviceName_.c_str() };
			eventLog_.reportEvent(
				MSG_JAVAVM_EXITED,
				2,
				mes,
				EVENTLOG_INFORMATION_TYPE
				);

			// ~
			serviceStatus.dwCurrentState = SERVICE_STOPPED;
			serviceStatus.dwControlsAccepted = 0;
			SetServiceStatus( hServiceStatus, &serviceStatus );
		}

		virtual void notifyJVMAborted() throw()
		{
			notifyJVMLog( "[jvmservice: JavaVMabort܂B]\n" );
			const char* mes[] = { serviceName_.c_str() };
			eventLog_.reportEvent(
				MSG_JAVAVM_ABORTED,
				1,
				mes,
				EVENTLOG_ERROR_TYPE
				);

			// ~
			serviceStatus.dwCurrentState = SERVICE_STOPPED;
			serviceStatus.dwControlsAccepted = 0;
			SetServiceStatus( hServiceStatus, &serviceStatus );
		}

		virtual void notifyException( const std::string& v_exceptionReason ) throw()
		{
			notifyJVMLog( "[jvmservice: O܂B:%s]\n", v_exceptionReason.c_str() );
			const char* mes[] = { v_exceptionReason.c_str() };
			eventLog_.reportEvent(
				MSG_JAVAVM_EXCEPTION,
				1,
				mes,
				EVENTLOG_ERROR_TYPE
				);
		}

		virtual int notifyJVMLog( FILE* v_fp, const char* v_format, va_list v_args ) throw()
		{
			if( jvmLog_ != NULL ) {
				int cnt = vfprintf( jvmLog_, v_format, v_args );
				fflush( jvmLog_ );
				return cnt;
			}
			return 0;
		}

		virtual void notifyJVMLog( const char* v_format, ... ) throw()
		{
			va_list marker;
			va_start( marker, v_format );
			notifyJVMLog( NULL, v_format, marker );
		}

		virtual void notifyJVMThreadNormalyTerminated( const std::string& v_target ) throw()
		{
			notifyJVMLog( "[jvmservice: Xbh~܂B(config=%s)]\n", v_target.c_str() );
			const char* mes[] = { v_target.c_str() };
			eventLog_.reportEvent(
				MSG_JAVAVM_THREAD_NORMALY_TERMINATED,
				1,
				mes,
				EVENTLOG_INFORMATION_TYPE
				);
		}

		virtual void notifyJVMThreadAbnomalTerminated( const std::string& v_target, const std::string& v_reason ) throw()
		{
			notifyJVMLog( "[jvmservice: XbhOɂ~܂B(config=%s)(reason=%s)]\n", v_target.c_str(), v_reason.c_str() );
			const char* mes[] = { v_target.c_str(), v_reason.c_str() };
			eventLog_.reportEvent(
				MSG_JAVAVM_THREAD_ABNORMAL_TERMINATED,
				2,
				mes,
				EVENTLOG_ERROR_TYPE
				);
		}

		virtual void notifyLibraryLoadFailure( const std::string& v_dllPath ) throw()
		{
			notifyJVMLog( "[jvmservice: DLL̓ǂݍ݂Ɏs܂B:%s]\n", v_dllPath.c_str() );
			const char* mes[] = { v_dllPath.c_str() };
			eventLog_.reportEvent(
				MSG_PRELOADLIB_FAILURE,
				1,
				mes,
				EVENTLOG_ERROR_TYPE
				);
		}

	private:
		std::string serviceName_;
		FILE* jvmLog_;
		EventLog& eventLog_;
	};

	/*!
	 * IɃN[ibv̂߂ɌĂяo郋[`
	 */
	void cleanup()
	{
		if( pEventListener_ != NULL ) {
			delete pEventListener_;
			pEventListener_ = NULL;
		}

		if( pEventLog_ != NULL ) {
			delete pEventLog_;
			pEventLog_ = NULL;
		}

		if( jvmLogFP_ != NULL ) {
			fputs( "** END **\n", jvmLogFP_ );
			fclose( jvmLogFP_ );
			jvmLogFP_ = NULL;
		}
	}

	/*!
	 * W[̃tpXgqŎw肵Œu܂B
	 * uɎsꍇ͋󕶎Ԃ܂B
	 * \param v_ext ugq
	 * \return uꂽA܂͋󕶎
	 */
	std::string GetConfPath( const std::string& v_ext ) throw()
	{
		CHAR preloadConfPath[ MAX_PATH + 9 ];
		preloadConfPath[ GetModuleFileName( NULL, preloadConfPath, MAX_PATH ) ] = 0;
		LPSTR p = preloadConfPath;
		while(*p)p++;
		while( p > preloadConfPath && *p != '\\' ) {
			if( *p == '.' ) {
				strcpy( p, v_ext.c_str() );
				break;
			}
			p = CharPrev( preloadConfPath, p );
		}
		if( p == preloadConfPath || *p == '\\' ) {
			return std::string();
		}
		return std::string( preloadConfPath );
	}

	DWORD WINAPI service_handler(
		DWORD dwControl,     // vR[h
		DWORD dwEventType,   // Cxg̃^Cv
		LPVOID lpEventData,  // Cxg̃f[^
		LPVOID lpContext     // [U[`̃ReLXgf[^
	) throw()
	{
		DWORD retCode = ERROR_CALL_NOT_IMPLEMENTED;

		if( dwControl == SERVICE_CONTROL_STOP || dwControl == SERVICE_CONTROL_SHUTDOWN ) {
			pEventListener_->notifyJVMLog(
				( dwControl == SERVICE_CONTROL_STOP ) ?
				"[SERVICECONTROL] SERVICE_CONTROL_STOP\n" :
				"[SERVICECONTROL] SERVICE_CONTROL_SHUTDOWN\n"
				);
			if( pJVMLauncher_ != NULL ) {
				serviceStatus.dwCurrentState = SERVICE_STOP_PENDING;
				serviceStatus.dwControlsAccepted = 0;
				SetServiceStatus( hServiceStatus, &serviceStatus );

				pJVMLauncher_->shutdown();
			}
			else {
				serviceStatus.dwCurrentState = SERVICE_STOPPED;
				serviceStatus.dwControlsAccepted = 0;
			}
			retCode = NO_ERROR;
		}
		else if( dwControl == SERVICE_CONTROL_INTERROGATE ) {
			retCode = NO_ERROR;
		}

		SetServiceStatus( hServiceStatus, &serviceStatus );
		
		return retCode;
	}

	void WINAPI service_main( DWORD argc, LPSTR* argv ) throw()
	{
		// N[ibv̓o^
		SetProcessShutdownParameters( 0x300, 0 );
		atexit( cleanup );

		// CxgȌ
		pEventLog_ = new EventLog( szServiceName_ );
		pEventLog_->open();

		// JVMOt@C̃obNAbvƍ쐬
		std::string jvmLogPath( szLogPath_ );
		if( ! jvmLogPath.empty() ) {
			std::string jvmLogBakPath( jvmLogPath + ".bak" );
			DeleteFile( jvmLogBakPath.c_str() );
			MoveFile( jvmLogPath.c_str(), jvmLogBakPath.c_str() );
			jvmLogFP_ = fopen( jvmLogPath.c_str(), "w" );
		}

		// CxgXȉ
		pEventListener_ = new JVMEventListenerImpl( szConfigPath_, jvmLogFP_, *pEventLog_ );

		hServiceStatus = RegisterServiceCtrlHandlerEx( szServiceName_, service_handler, NULL );
		if( hServiceStatus != NULL ) {

			serviceStatus.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
			serviceStatus.dwControlsAccepted = SERVICE_ACCEPT_SHUTDOWN | SERVICE_ACCEPT_STOP;
			serviceStatus.dwCurrentState = SERVICE_START_PENDING;
			SetServiceStatus( hServiceStatus, &serviceStatus );

			// JVM̍쐬Ǝs
			JVMLauncher jvmLauncher( *pEventListener_ );
			pJVMLauncher_ = &jvmLauncher;

			try{
				const std::string preloadConfPath( GetConfPath( ".preload" ) );
				jvmLauncher.preloadLibrary( preloadConfPath );
			}
			catch( const Win32Exception& v_exception ) {
				serviceStatus.dwCurrentState = SERVICE_STOPPED;
				serviceStatus.dwWin32ExitCode = v_exception.getErrorCode();
				SetServiceStatus( hServiceStatus, &serviceStatus );
				exit( 3 );
			}
			
			try{
				// Jn
				serviceStatus.dwCurrentState = SERVICE_RUNNING;
				SetServiceStatus( hServiceStatus, &serviceStatus );
				
				jvmLauncher.launchJVM( szConfigPath_ );
			}
			catch( ... ) {
				serviceStatus.dwCurrentState = SERVICE_STOPPED;
				serviceStatus.dwWin32ExitCode = ERROR_SERVICE_SPECIFIC_ERROR;
				serviceStatus.dwServiceSpecificExitCode = 0;
				SetServiceStatus( hServiceStatus, &serviceStatus );
				exit( 3 );
			}

			jvmLauncher.switchToJVM();

			// Wu~߂̂܂ɕʂɏIꍇ
			pEventListener_->notifyJVMExited( 0 );
		}

		exit( 0 );
	}
}

void service_dispatcher( const CommandArgument& v_argument ) throw ( std::exception )
{
	//required:
	assert( ! v_argument.getServiceName().empty() );
	assert( ! v_argument.getConfigPath().empty() );

	//do:
	strncpy( szServiceName_, v_argument.getServiceName().c_str(), MAX_PATH );
	strncpy( szConfigPath_, v_argument.getConfigPath().c_str(), MAX_PATH );
	strncpy( szLogPath_, v_argument.getLogPath().c_str(), MAX_PATH );
	szServiceName_[ MAX_PATH ] = 0;
	szConfigPath_[ MAX_PATH ] = 0;
	szLogPath_[ MAX_PATH ] = 0;

	//fBNg̕ύX
	if( ! v_argument.getWorkDir().empty() ) {
		_chdir( v_argument.getWorkDir().c_str() );
	}

	SERVICE_TABLE_ENTRY serviceEntries[] = {
		{ szServiceName_, service_main },
		NULL
	};
	if( ! StartServiceCtrlDispatcher( serviceEntries ) ) {
		throw std::runtime_error( "T[rX̋NɎs܂B" );
	}
}
