// $Id: b_transition.h,v 1.4 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    b_transition.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef B_TRANSITION_H
#define B_TRANSITION_H

#include "b_ace.h"

class b_state;
class b_trigger;
class b_context;

// Forward declaration
typedef const BCHAR * (*TriggerAction)(b_context * root, b_trigger * trig);


//----------------------------------------------------------------------------
//
// Transition
//
//----------------------------------------------------------------------------
class BEE_Export b_transition
{
public:
    b_transition(const BCHAR * name, b_statype * state, const BCHAR * trig,
                 TriggerAction act):
            m_name((name) ? name : _TX("")), m_trigger((trig) ? trig : _TX("")),
            m_statype(state), m_act(act) {}
    virtual ~b_transition() {}

    virtual const BCHAR * act(b_context * root, b_trigger * trig) {
            return (*m_act)(root, trig);
        }
    virtual b_transition * generate(b_statype * statype) {
            b_transition * gen = new b_transition(m_name.c_str(), statype,
                                                  m_trigger.c_str(), m_act);
            return gen;
        }

    b_statype * stateType() const   { return m_statype; }
    void  stateType(b_statype * st) { m_statype = st; }
    const string& trigger() const   { return m_trigger; }
    const string& stateName() const { return m_statype->name(); }
    const string& name()     { return m_name; }
    const BCHAR * charName() { return m_name.c_str(); }
    bool  decided() const { return (m_act == NULL) ? true : false; }
    void  dump() const;

//
protected:
    string  m_name;
    string  m_trigger;
    b_statype * m_statype;
    TriggerAction  m_act;
};


//----------------------------------------------------------------------------
class BEE_Export b_nextransit : public b_transition
{
public:
    b_nextransit(const BCHAR * name, b_statype * stype, const BCHAR * trigger,
                 const BCHAR * next)
        : b_transition(name, stype, trigger, NULL), m_nextate(next) {}
    virtual ~b_nextransit() {}

    virtual const BCHAR * act(b_context * root, b_trigger * trig) {
            ACE_UNUSED_ARG(root);
            ACE_UNUSED_ARG(trig);
            return m_nextate.c_str();
        }
    virtual b_transition * generate(b_statype * statype) {
            b_nextransit * gen = new b_nextransit(m_name.c_str(), statype,
                                                  m_trigger.c_str(),
                                                  m_nextate.c_str());
            return gen;
        }
    void dump() const;

//
private:
    string m_nextate;
};


#endif
