// $Id: b_trigger.h,v 1.4 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    b_trigger.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef B_TRIGGER_H
#define B_TRIGGER_H


#include "b_ace.h"
#include "b_command.h"

// Forward declaration
class b_context;
class b_trigger;

//-----------------------------------------------------------------------------
//
// Trigger type
//
//-----------------------------------------------------------------------------
template<class T>
class b_trigtype
{
public:
    b_trigtype(const BCHAR * name) : m_name(name) {}
    virtual ~b_trigtype() {}

    T * create() { return (new T(this)); }

protected:
    b_trigtype() : m_name("") {}

//
protected:
    string m_name;
};

typedef b_trigtype<b_trigger> Trigger;

//-----------------------------------------------------------------------------
//
// Trigger
//
//-----------------------------------------------------------------------------
class b_trigger : public b_command
{
public:
    b_trigger(const string& cmd) : b_command(cmd) {
            m_birth = ACE_OS::gettimeofday();
            m_life = ACE_Time_Value::zero;
        }
    b_trigger(const string& cmd, b_object * obj) : b_command(cmd, obj) {
            m_birth = ACE_OS::gettimeofday();
            m_life = ACE_Time_Value::zero;
        }
    b_trigger(const string& cmd, b_object * obj, const string& dest,
              const string& from) : b_command(cmd, obj, dest, from) {
            m_birth = ACE_OS::gettimeofday();
            m_life = ACE_Time_Value::zero;
        }
    b_trigger(const string& cmd, const string& dest, const string& from)
            : b_command(cmd, dest, from) {
            m_birth = ACE_OS::gettimeofday();
            m_life = ACE_Time_Value::zero;
        }
    b_trigger(const b_trigger& rhs) : b_command(rhs) {
            m_birth = rhs.m_birth;
            m_life = rhs.m_life;
        }

    b_trigger& operator=(const b_trigger& rhs) {
            if (this == &rhs)
                return *this;
            this->copy(rhs);
            return *this;
        }
    ~b_trigger() {}

    void  dump() const {
            ACE_DEBUG((LM_DEBUG, ACE_TEXT("trigger name = %s, "),
                                 this->m_subject.c_str()));
        }

protected:
    b_trigger() : b_command() {
            m_birth = ACE_OS::gettimeofday();
            m_life = ACE_Time_Value::zero;
        }
    void copy(const b_trigger& rhs) {
            this->b_command::copy(rhs);
            m_birth = rhs.m_birth;
            m_life = rhs.m_life;
        }

// member variables
protected:
    ACE_Time_Value m_birth;
    ACE_Time_Value m_life;
};


#endif
