// $Id: JGCommand.h,v 1.7 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGCommand.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGCOMMAND_H
#define JGCOMMAND_H

#include "ecm.h"
#include "JGTrigger.h"

class JGObject;

//
// Remote command parameter
//
typedef b_param RCmdParam;

//
// Remote command
//
class BEE_Export JGCommand : public JGTrigger
{
public:
    enum { PROG_EQUIPMENT, PROG_FACTORY, PROG_GEM };

public:
    JGCommand() : JGTrigger() {}
    JGCommand(const string& cmd) : JGTrigger(cmd) {}
    JGCommand(const string& cmd, JGObject * obj) : JGTrigger(cmd, obj) {}
    JGCommand(const string& cmd, JGObject * obj, const string& dest,
              const string& from) : JGTrigger(cmd, obj, dest, from) {}
    JGCommand(const string& cmd, const string& dest, const string& from)
            : JGTrigger(cmd, dest, from) {}
    JGCommand(const JGCommand& rhs)
            : JGTrigger(rhs), m_response(rhs.m_response), m_reqid(rhs.m_reqid),
              m_linkid(rhs.m_linkid), m_prog(rhs.m_prog) {}
 
    JGCommand& operator=(const JGCommand& rhs) {
            if (this == &rhs)
                return *this;
            this->copy(rhs);
            return *this;
        }

    inline JGObject * getObject() { return (JGObject *)this->b_command::getObject(); }
    inline void setObject(JGObject * obj) { this->b_command::setObject((b_object *)obj); }

    u_int getRequestID()         { return m_reqid; }
    void  setRequestID(u_int id) { m_reqid = id; }

    bool  isResponse()        { return m_response; }
    void  setResponse(bool f) { m_response = f; }

    u_int getLinkID()         { return m_linkid; }
    void  setLinkID(u_int id) { m_linkid = id; m_response = true; }

    bool  fromHost()        { return (m_prog == PROG_FACTORY); }
    bool  fromApplication() { return (m_prog == PROG_EQUIPMENT); }
    void  issueFrom(int pg) { m_prog = pg; }

    void toString(string& xml) {}

protected:
    void copy(const JGCommand& rhs) {
            this->JGTrigger::copy(rhs);
            m_reqid = rhs.m_reqid;
            m_response = rhs.m_response;
            m_linkid = rhs.m_linkid;
            m_prog = rhs.m_prog;
        }

protected:
    bool   m_response;
    u_int  m_reqid;
    u_int  m_linkid;
    int    m_prog;            // Program issued from
};

#endif  /* JGCOMMAND_H */
