// $Id: JGDataBase.h,v 1.4 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGDataBase.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGDATABASE_H
#define JGDATABASE_H

#include "ecm.h"
#undef _stscanf
#undef _tcsdup
#undef MIN
#undef MAX
#include "DTL.h"
using namespace dtl;

//
// DataBase Wrapper Class
//
class BEE_Export JGDataBase
{
public:
    JGDataBase(const BCHAR * root = NULL);
    virtual ~JGDataBase();

    virtual int  init(long = 0);
    virtual int  load();
    virtual int  save();

    void    rootName(const string& root) { m_root = root; }
    string& rootName()                   { return m_root; }

    static JGDataBase * instance();
    static int connect(const string& mdb);
    static int release();
    static void errdb(const string& funcName, const string& mdb,
                      dtl::RootException& ex);

//
protected:

// member variables
protected:
    string m_dsn;
    string m_root;
};


#endif  /* JGDATABASE_H */
