// $Id: JGDevAttrData.h,v 1.3 2003/02/02 15:56:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGDevAttrData.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGDEVATTRDATA_H
#define JGDEVATTRDATA_H

#include "ecm.h"
#include "JGDevAttribute.h"

class JGDevObject;

//
// Attribute Data Class
//
class BEE_Export JGDevAttrData : public b_attrdata
{
public:
    JGDevAttrData(JGDevObject * obj, JGDevAttribute * attr);
    JGDevAttrData(const JGDevAttrData& rhs) : b_attrdata(rhs) {}
    ~JGDevAttrData() {}

    JGDevAttrData& operator=(const JGDevAttrData& rhs) {
            if (this == &rhs)
                return *this;
            this->b_attrdata::operator=(rhs);
            return *this;
        }

    const PLCAddress& address() const { return (this->getAttribute()->address()); }
    const JGDevObject * getObject() const {
            return reinterpret_cast<const JGDevObject *>(m_obj);
        }
    const JGDevAttribute * getAttribute() const {
            return reinterpret_cast<const JGDevAttribute *>(m_attr);
        }

    void dump() const;

// Member variables
protected:

};

#endif  /* JGDEVATTRDATA_H */
