// $Id: JGDevAttribute.h,v 1.3 2003/02/02 15:56:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGDevAttribute.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGDEVATTRIBUTE_H
#define JGDEVATTRIBUTE_H

#include "ecm.h"
#include "PLCMemory.h"

class JGDevType;
class JGDevAttrData;

//
// Attribute of Class
//
class BEE_Export JGDevAttribute : public b_attribute
{
public:
    JGDevAttribute(JGDevType& clazz, const BCHAR * name, int type, size_t size,
              const PLCAccess& paddr, bool comp);
    ~JGDevAttribute() {}

    bool  isCompare() const          { return m_comp; }
    const PLCAccess& address() const { return m_addr; }
    int   getValue(JGvalue& value) const;

    void dump() const;

// Member variables
protected:
    PLCAccess m_addr;
    bool      m_comp;
};

#endif  /* JGDEVATTRIBUTE_H */
