// $Id: JGDevType.h,v 1.3 2003/02/02 15:56:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGDevType.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGDEVTYPE_H
#define JGDEVTYPE_H

#include "ecm.h"
#include "PLCAddress.h"

class JGDevObject;
class JGObserver;
// Define container
typedef vector<JGObserver *> JGObservers;

//
// Object
//
class BEE_Export JGDevType : public b_objtype
{
public:
    enum { DISABLE = 0, CYCLE = 1, CHANGED = 2 };
    enum { UNKNOWN = -1, WATCHING = 0, START = 1, STOP = 2 };

    JGDevType(const string& name): b_objtype(name), m_seq(0), m_enable(true),
                                   m_trigType(CHANGED), m_latch(false),
                                   m_pause(false), m_last(NULL) {}
    ~JGDevType() {}

    int  trigMode()  const   { return m_trigType; }
    int  condition() const   { return m_status; }
    int  condition(int cond) {
            int result = m_status; m_status = cond; return result;
        }
    bool enable() { return m_enable; }
    bool latch()  { return m_latch;  }
    bool pause()  { return m_pause;  }
    bool latchStatus();
    bool pauseStatus();
    bool checkAndSet(const JGDevObject * current);
    int  releaseLast();

    void  set(bool enable, int trigger, bool latch, bool pause,
              PLCAccess& access, PLCAccess& paddr) {
            m_enable = enable; m_latch = latch; m_pause = pause;
            m_trigType = trigger; m_watchAdr = access; m_pauseAdr = paddr;
        }
    void  add(JGObserver * observer)    { m_observers.push_back(observer); }
    const JGObservers& observers() const { return m_observers; }
    void  dump() const;

    JGDevObject * instance();                // Create object
    static int  destroy(JGDevObject * obj);  // Delete object

//
protected:
    UINT      m_seq;        // Additinal sequence number to object
    bool      m_enable;
    int       m_trigType;
    bool      m_latch;
    bool      m_pause;
    int       m_status;     // -1:unknown, 0:observe, 1:start, 2:stop
    PLCAccess m_watchAdr;
    PLCAccess m_pauseAdr;
    JGObservers m_observers;
    JGDevObject * m_last;
};

#endif  /* JGDEVTYPE_H */
