// $Id: JGEquipmentModule.h,v 1.3 2003/02/02 15:56:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGEquipmentModule.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGEQUIPMENTMODULE_H
#define JGEQUIPMENTMODULE_H

#include "JGPLCManager.h"
#include "JGXmlParser.h"

class PLCDeviceManager;

/*
 * Equipment module (I/O device management) class
 */
class BEE_Export JGEquipmentModule
{
public:
    JGEquipmentModule();
    ~JGEquipmentModule() {}

    int init(int argc, char ** argv);
    int fini(long = 0);

    const string& root() const { return m_rootPath; }
    const string& plcName() const { return m_plcName; }
    JGPLCManager& iodev() { return m_iodevs; }
    JGXmlParser&  xml()   { return m_xmlParser; }
//
protected:
    int parseArgs(int argc, char ** argv);

//
protected:
    bool   m_debug;
    string m_dsn;
    string m_rootPath;
    string m_plcName;
    JGPLCManager m_iodevs;
    JGXmlParser  m_xmlParser;
};

#endif  /* JGEQUIPMENTMODULE_H */
