// $Id: JGFile.cpp,v 1.3 2003/02/23 10:58:38 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGFileManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "b_ace.h"
#include "ace/Get_Opt.h"
#include "ace/FILE_Addr.h"
#include "ace/FILE_Connector.h"
#include "ace/FILE_IO.h"
#include "ace/SOCK_Acceptor.h"
#include "ace/Timer_Heap_T.h"
#include "ace/Timer_Queue_Adapters.h"
#include "JGFileManager.h"

//-----------------------------------------------------------------------------
// Make file name (static)
//-----------------------------------------------------------------------------
void JGFile::makeFileName(const string& dir, const string& fname,
                          const string& ext, string& path)
{
    path = dir;
    if (path.at(dir.size() - 1) != DIR_SEPARATOR_CHAR)
    {
        path.append(1, DIR_SEPARATOR_CHAR);
    }
    path.append(fname);
    if (ext.size() > 0)
    {
        if (ext.at(0) != '.')
        {
            path.append(1, '.');
        }
        path.append(ext);     // path that make file.
    }
}

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
JGFile::JGFile(const string& dir, const string& fname, const string& ext)
{
    JGFile::makeFileName(dir, fname, ext, m_fileName);
}

//-----------------------------------------------------------------------------
// Open the file
//-----------------------------------------------------------------------------
int JGFile::open(int mode)
{
    TRACE_FUNCTION(TRL_LOW, "JGFile::open");

    if (m_fileName.size() <= 0)
    {
        TRACE_DEBUG((_TX("Empty file name\n")));
        return -1;
    }
    ACE_FILE_Connector connector;
    int result = connector.connect(m_file,
                           ACE_FILE_Addr(m_fileName.c_str()),
                           0,                 // No timeout.
                           ACE_Addr::sap_any, // Ignored.
                           0,                 // Don't try to reuse the addr.
                           O_RDWR | O_CREAT | mode,
                           ACE_DEFAULT_FILE_PERMS);
    if (result < 0)
    {
        TRACE_ERROR((_TX("Error connect text file (%s)\n"),
                     m_fileName.c_str()));
        return -1;
    }

    // TRACE_DEBUG((_TX("Connect text file : %s\n"), m_fileName.c_str()));

    m_opened = true;
    return 0;
}

//-----------------------------------------------------------------------------
// Write data
//-----------------------------------------------------------------------------
int JGFile::write(const string& textstr)
{
    TRACE_FUNCTION(TRL_LOW, "JGFile::write");

    if (m_file.send_n(textstr.c_str(), textstr.size()) == -1)
    {
        TRACE_ERROR((_TX("%p\n"), _TX("file.send_n()")));
        return -1;
    }
    return 0;
}

//-----------------------------------------------------------------------------
int JGFile::write(const BYTE * buf, size_t size)
{
    TRACE_FUNCTION(TRL_LOW, "JGFile::write");

    if (m_file.send_n(buf, size) == -1)
    {
        TRACE_ERROR((_TX("%p\n"), _TX("file.send_n()")));
        return -1;
    }
    return 0;
}

//-----------------------------------------------------------------------------
// Read
//-----------------------------------------------------------------------------
int JGFile::read(BYTE * buf, size_t size)
{
    TRACE_FUNCTION(TRL_LOW, "JGFile::read");

    if (m_file.recv(buf, size) == -1)
    {
        TRACE_ERROR((_TX("%p\n"), _TX("file.read()")));
        return -1;
    }
    return 0;
}

//-----------------------------------------------------------------------------
// Get size
//-----------------------------------------------------------------------------
size_t JGFile::size()
{
    TRACE_FUNCTION(TRL_LOW, "JGFile::size");

    ACE_FILE_Info finfo;
    if (m_file.get_info(finfo) == -1)
    {
        TRACE_ERROR((_TX("%p\n"), _TX("file.get_info()")));
        return 0;
    }
    return (size_t)finfo.size_;
}

