// $Id: JGFileManager.h,v 1.4 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGFileManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGFILEMANAGER_H
#define JGFILEMANAGER_H

#include "JGFile.h"

class JGLogTime;

//-----------------------------------------------------------------------------
//
// Plane file manager whitch format are csv, xml or secs.
//
//-----------------------------------------------------------------------------
class BEE_Export JGFileManager
{
public:
    JGFileManager(const string& path, const string& ext,
                  bool del = false)
            : m_append(false), m_remove(false), m_rootPath(path), m_ext(ext)  {}
    virtual ~JGFileManager() {}

    int init(const BCHAR ** categories, const string& key);
    int change(const string& key);

    // Write data to file
    int write(const string& category, const string& text);
    int write(const string& category, const JGLogTime& logtime, const string& text);

    // Close file
    int close();                   // All files
    int close(const string& category);

    // Set/Get flags
    bool isRemove()          { return m_remove; }

protected:
    JGFileManager() : m_append(false), m_remove(false), m_rootPath(_TX("")),
                      m_ext(_TX("")) {}
    JGFile * find(const string& category);
    JGFile * create(const string& category, const string& key);

// member variables
protected:
    bool       m_append;        // Mode is append or not when create file
    bool       m_remove;
    string     m_rootPath;      // text files path name
    string     m_ext;           // file extention
    JGFileMap  m_files;
};

#endif /* JGFILEMANAGER_H */
