// $Id: JGTask.h,v 1.7 2003/02/23 10:58:38 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGTask.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGTASK_H
#define JGTASK_H

#include "ecm.h"
#include "JGTrigger.h"

// Forword declaration
class JGTask;
class JGObserver;

//------------------------------------------------------------------------------
// The class which supervises the term of service.
//------------------------------------------------------------------------------
class BEE_Export TaskTimerHandler : public ACE_Handler
{
public:
    TaskTimerHandler() : ACE_Handler(), m_tmid(0), m_task(NULL) {}
    virtual ~TaskTimerHandler(void) {}

    // Store an "id" for the Handler, which is only use to print better
    // messages.
    void set_id(int id) { this->m_tmid = id; }
    void set_task(JGTask * task) { this->m_task = task; }

    // Call back hook.
    virtual void handle_time_out(const ACE_Time_Value& tv, const void * arg) = 0;

    // The handler was cancelled, so we must delete this.
    virtual int cancelled(void) { delete this; return 0; }

protected:
    // Store an "id" for the Handler, which is only use to print better
    // messages.
    int m_tmid;

    JGTask * m_task;
};

//------------------------------------------------------------------------------
//
// Service task base class
//
//------------------------------------------------------------------------------
class BEE_Export JGTask : public MT_Task
{
    //
    // Ending trigger of own
    //
    class TaskEndRequest : public ACE_Method_Request
    {
    public:
        TaskEndRequest(JGTask * task = NULL)
                : ACE_Method_Request(), m_task(task) {}
        virtual ~TaskEndRequest(void) {}
        virtual int call(void) { return -1; }    // Shut down the task.

    private:
        JGTask * m_task;
    };

public:
    virtual ~JGTask() {}

    const string& name() const     { return m_program; }
    const BCHAR * charName() const { return m_program.c_str(); }

    virtual int open(void * args = 0);
    virtual int close(u_long flags = 0);
    virtual int svc(void);
    virtual int end();

    // interface for other tasks
    virtual int notify(JGTrigger * trigger);
    virtual int put(JGTriggerRequest * req);

    // attach/detach observer task
    int attach(JGObserver * observer);
    int detach(JGObserver * observer);

protected:
    JGTask(const string& name);
    int addTimer(const ACE_Time_Value& interval, TaskTimerHandler * tmh);
    int cancelTimer(int timer_id);  // Cancel timer <id>.

// member variables
protected:
    string m_program;
    ACE_Thread_Mutex     m_tmlock;    // mutex for timer thread
    ACE_Activation_Queue m_activation_queue;

    JGObserver * m_observer;
};

#endif  /* JGTASK_H */
