// $Id: JGAccessManager.h,v 1.1 2003/02/16 17:04:53 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGAccessManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGACCESSMANAGER_H
#define JGACCESSMANAGER_H

#include "JGManager.h"
#include "JGRemoteCmd.h"

class JGErrorList;

/*
 * Process Manager Class
 */
class BEE_Export JGAccessManager : public JGManager
{

public:
    JGAccessManager();
    virtual ~JGAccessManager() {}

    virtual int init(void * = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int ope_svc(JGOperatorTrigger * trigger);

    virtual int notify(const string& objspec, const string& cmd,
                       const string& param);
    virtual int notify(const string& category, JGVariable * var,
                       void * arg = NULL);

    static JGAccessManager * instance();

private:
    BS2Message * hostCommand(BS2Message * msg);             // S2F41
    BS2Message * enhancedRemoteCommand(BS2Message * msg);   // S2F49
    int validateParams(JGService * rcmd, JGErrorList& errs);

//member variables
private:
    JGRemoteCmdTable m_rcmdTable;

    JGVariable * m_indicator;
    JGVariable * m_opecmd;
    JGVariable * m_remoteCmd;
    JGVariable * m_localCmd;
};

#endif
