// $Id: JGBitsetSub.h,v 1.3 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGBitsetSub.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGBITSETSUB_H
#define JGBITSETSUB_H

#include "JGTriggerInfo.h"

class JGBitsetSub;

class JGBitsetSubBase : public JGTriggerSubject
{
public:
    JGBitsetSubBase(): JGTriggerSubject(), m_entity(NULL) {}
    JGBitsetSubBase(const JGTriggerSubject& rhs)
            : JGTriggerSubject(rhs), m_entity(NULL) {}
    virtual ~JGBitsetSubBase() {}

    JGBitsetSubBase& operator=(const JGBitsetSubBase& rhs);
    virtual JGTriggerInfo * factory() { return NULL; }
    virtual JGTriggerInfo * entity();
    virtual bool            isGroup() { return true; }

    int parse();
    string& enumerate(int num) {
            return (num < (int)m_enames.size()) ?
                        m_enames[num] : JGTriggerSubject::_NilString;
        }

protected:
    vector<string> m_enames;
    JGBitsetSub * m_entity;
};


//
// Subject for BitSet
//
typedef JGTriggerInfoTempl<JGBitsetSubBase> JGTrigBitset;

class JGBitsetSub : public JGTrigBitset
{
public:
    JGBitsetSub(JGBitsetSubBase * base): JGTrigBitset(base) {}
    virtual ~JGBitsetSub() {}

    virtual int init();
    virtual int changed(vector<JGVariable *>& vars);

    string& enumerate(int num) {
            return m_subject->enumerate(num);
        }

    bool entry()           { return m_entry; }
    void entry(bool yesno) { m_entry = yesno; }

private:
    bool       m_entry;

};


#endif  /* JGBITSETSUB_H */
