// $Id: JGErrorList.cpp,v 1.4 2003/02/16 17:04:53 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGErrorList.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGErrorList.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"

static BCHAR * _errtext[] =
{
    _TX(""),                                     // 0
    _TX("Unknown object in Object Specifier"),   // 1
    _TX("Unknown target object type"),           // 2
    _TX("Unknown object instance"),              // 3
    _TX("Unknown attribute name"),               // 4
    _TX("Read-only attribute - access denied"),  // 5
    _TX("Unknown object type"),                  // 6
    _TX("Invalide attribute value"),             // 7
    _TX("Syntax error"),                         // 8
    _TX("Verification error"),                   // 9
    _TX("Validation error"),                     // 10
    _TX("Object identifier in use"),             // 11
    _TX("Parameters improperly specified"),      // 12
    _TX("Insufficient parameters specified"),    // 13
    _TX("Unsupported option requested"),         // 14
    _TX("Busy"),                                 // 15
    _TX("Not available for processing"),         // 16
    _TX("Command not valid for current state"),  // 17
    _TX("No material altered"),                  // 18
    _TX("Material partially processed"),         // 19
    _TX("All material processed"),               // 20
    _TX("Recipe specification related error"),   // 21
    _TX("Failed during processing"),             // 22
    _TX("Failed while not processing"),          // 23
    _TX("Failed due to lack of material"),       // 24
    _TX("Job aborted"),                          // 25
    _TX("Job stopped"),                          // 26
    _TX("Job cancelled"),                        // 27
    _TX("Cannot change selected recipe"),        // 28
    _TX("Unknown event"),                        // 29
    _TX("Duplicate report ID"),                  // 30
    _TX("Unknown Data report"),                  // 31
    _TX("Data report not linked"),               // 32
    _TX("Unknown trace report"),                 // 33
    _TX("Duplicate trace ID"),                   // 34
    _TX("Too many data reports"),                // 35
    _TX("Sample period out of range"),           // 36
    _TX("Group size to large"),                  // 37
    _TX("Recovery action currently invalid"),    // 38
    _TX("Busy with another recovery currently unable to perform the recovery"),   // 39
    _TX("No active recovery action"),            // 40
    _TX("Exception recovery failed"),            // 41
    _TX("Exception recovery aborted"),           // 42
    _TX("Invalid table element"),                // 43
    _TX("Unknown table element"),                // 44
    _TX("Cannot delete predefined"),             // 45
    _TX("Invalid token"),                        // 46
    _TX("Invalid parameter"),                    // 47
    NULL                                         // tail
};


//-----------------------------------------------------------------------------
// Make error item
//-----------------------------------------------------------------------------
BS2Item * JGError::makeItem(int codeType) const
{
    TRACE_FUNCTION(TRL_LOW, "JGError::makeItem");
    BS2ListItem * listitem = new BS2ListItem;
    BS2Atom * atom;
    if (codeType == ATOM_UINT4)
    {
        atom = new BS2UInt4(m_code);
    }
    if (codeType == ATOM_UINT1)
    {
        atom = new BS2UInt1((BYTE)m_code);
    }
    else if (codeType == ATOM_UINT2)
    {
        atom = new BS2UInt2((USHORT)m_code);
    }
    else /* ATOM_UINT8 */
    {
        atom = new BS2UInt8(m_code);
    }
    BS2Item * item = BS2Item::factory(_TX("ERRCODE"), atom);
    listitem->add(item);
    atom = new BS2Ascii(m_text);
    item = BS2Item::factory(_TX("ERRTEXT"), atom);
    listitem->add(item);

    return listitem;
}

//-----------------------------------------------------------------------------
BS2Item * JGError::cpackItem(int cpackType) const
{
    TRACE_FUNCTION(TRL_LOW, "JGError::makeItem");
    BS2ListItem * listitem = new BS2ListItem;
    BS2Atom * atom = new BS2Ascii(m_text);
    BS2Item * item = BS2Item::factory(_TX("CPNAME"), atom);
    listitem->add(item);

    if (cpackType == ATOM_BINARY)
    {
        atom = new BS2Binary((BYTE)m_code);
    }
    else /* if (cpackType == ATOM_UINT1) */
    {
        atom = new BS2UInt1((BYTE)m_code);
    }
    item = BS2Item::factory(_TX("CPACK"), atom);  // or CEPACK
    listitem->add(item);

    return listitem;
}

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
JGErrorList::JGErrorList(const JGErrorList& rhs)
{
    copy(rhs);
}

//-----------------------------------------------------------------------------
// Copy members
//-----------------------------------------------------------------------------
JGErrorList& JGErrorList::operator=(const JGErrorList& rhs)
{
    if (this == &rhs)
        return *this;
    this->copy(rhs);
    return *this;
}

//-----------------------------------------------------------------------------
void JGErrorList::copy(const JGErrorList& rhs)
{
    TRACE_FUNCTION(TRL_LOW, "JGErrorList::copy");

    m_name = rhs.m_name;
    m_format = rhs.m_format;
    m_errFormat = rhs.m_errFormat;
    m_ack = rhs.m_ack;
    m_errors = rhs.m_errors;
}

//-----------------------------------------------------------------------------
// Get error text by code
//-----------------------------------------------------------------------------
const BCHAR * JGErrorList::getErrText(u_long cd)
{
    return _errtext[cd];
}

//-----------------------------------------------------------------------------
// Make error list
//-----------------------------------------------------------------------------
BS2Item * JGErrorList::makeItem() const
{
    TRACE_FUNCTION(TRL_LOW, "JGErrorList::makeItem");
    BS2Atom * atom;
    BS2Item * item;
    BS2ListItem * baselist;
    BS2ListItem * listitem = new BS2ListItem;
    if (m_format == ATOM_UINT1)
    {
        atom = new BS2UInt1(m_ack);
    }
    else if (m_format == ATOM_BOOLEAN)
    {
        atom = new BS2Boolean((m_ack) ? true : false);
    }
    else
    {
        atom = new BS2Binary(m_ack);
    }
    item = BS2Item::factory(m_name.c_str(), atom);
    listitem->add(item);
    baselist = new BS2ListItem;
    listitem->add(baselist);

    // Convert all error data
    if (m_name == _TX("HCACK"))   // bad statement !
    {   // Remote Command Response
        JGErrors::const_iterator iter =  m_errors.begin();
        for ( ; iter != m_errors.end(); iter++)
        {
            const JGError * errdata = &(*iter);
            item = errdata->cpackItem(m_errFormat);
            baselist->add(item);
        }
    }
    else
    {   // OSS Message response
        JGErrors::const_iterator iter =  m_errors.begin();
        for ( ; iter != m_errors.end(); iter++)
        {
            const JGError * errdata = &(*iter);
            item = errdata->makeItem(m_errFormat);
            baselist->add(item);
        }
    }
    return listitem;
}

