// $Id: JGEvent.cpp,v 1.4 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGEvent.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEvent.h"
#include "JGReport.h"
#include "JGVariable.h"
#include "BS2ListItem.h"
#include "BS2ItemDictionary.h"
#include "BS2DeclAtoms.h"

//-----------------------------------------------------------------------------
// Constructor/Destructor.
//-----------------------------------------------------------------------------
JGEvent::JGEvent(const JGEvent& rhs) : JGNameInfo(rhs)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGRecipe::JGRecipe");
    m_enabled = rhs.m_enabled;
    m_category = rhs.m_category;
    m_action = rhs.m_action;

    m_manager = rhs.m_manager;
    m_rptset = rhs.m_rptset;
}

//-----------------------------------------------------------------------------
// Copy
//-----------------------------------------------------------------------------
JGEvent& JGEvent::operator=(const JGEvent& rhs)
{
    TRACE_FUNCTION(TRL_LOW, "JGRecipe::operator=");
    if (this == &rhs)
        return *this;
    this->copy(rhs);
    return *this;
}

//-----------------------------------------------------------------------------
void JGEvent::copy(const JGEvent& rhs)
{
    TRACE_FUNCTION(TRL_LOW, "JGRecipe::copy");
    this->JGNameInfo::copy(rhs);
    m_enabled = rhs.m_enabled;
    m_category = rhs.m_category;
    m_action = rhs.m_action;

    m_manager = rhs.m_manager;
    m_rptset = rhs.m_rptset;
}

//-----------------------------------------------------------------------------
// Create report data.
//-----------------------------------------------------------------------------
BS2Item * JGEvent::createReports(void * arg)
{
    TRACE_FUNCTION(TRL_LOW, "JGEvent::createReports");
    BS2ListItem * listitem = new BS2ListItem();
    BS2Item * item;

    JGReports::iterator iter = m_rptset.begin();
    for ( ; iter != m_rptset.end(); ++iter)
    {
        JGReport * rpt = *iter;
        item = rpt->create(arg);
        listitem->add(item);
    }

    return (BS2Item *)listitem;
}

//-----------------------------------------------------------------------------
// Erase report data.
//-----------------------------------------------------------------------------
int JGEvent::erase(JGReport * report)
{
    TRACE_FUNCTION(TRL_LOW, "JGEvent::erase");

    JGReports::iterator iter = m_rptset.begin();
    for ( ; iter != m_rptset.end(); ++iter)
    {
        JGReport * rpt = *iter;
        if ((rpt == report) || (rpt->rptid() == report->rptid()))
        {
            m_rptset.erase(iter);
            return BEE_SUCCESS;
        }
    }

    return BEE_ERROR;
}

//-----------------------------------------------------------------------------
bool JGEvent::exist(JGid& rptid)
{
    TRACE_FUNCTION(TRL_LOW, "JGEvent::exist");

    JGReports::iterator iter = m_rptset.begin();
    for ( ; iter != m_rptset.end(); ++iter)
    {
        JGReport * rpt = *iter;
        if (rpt->rptid() == rptid)
        {
            return true;
        }
    }
    return false;
}

//-----------------------------------------------------------------------------
// Print items of the event
//-----------------------------------------------------------------------------
void JGEvent::printOn(string& buf, int mode)
{
    TRACE_FUNCTION(TRL_LOW, "JGEvent::printOn");
    ACE_UNUSED_ARG(mode);

    string rptbuf;
    m_id.get(buf);
    buf += _TX(" ");
    buf += (m_enabled) ? _TX("true") : _TX("false");
    // Report ids
    buf += _TX(" {");
    JGReports::iterator iter = m_rptset.begin();
    for ( ; iter != m_rptset.end(); ++iter)
    {
        JGReport * rpt = *iter;
        rpt->rptid().get(rptbuf);
        buf += rptbuf;
        buf += _TX(" ");
    }
    buf += _TX("} ");
    return ;
}

