// $Id: JGEvent.h,v 1.3 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGEvent.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGEVENT_H
#define JGEVENT_H

#include "JGNameInfo.h"
#include "JGReport.h"

class BS2Item;
class JGEventManager;

// Define an object to hold configure data
class BEE_Export JGEvent : public JGNameInfo
{
public:
    JGEvent() : JGNameInfo(), m_enabled(false),
                m_category(_TX("")), m_action(_TX("")), m_manager(NULL) {}
    JGEvent(const JGEvent& rhs);
    virtual ~JGEvent() {}
    virtual void printOn(string& buf, int mode = 0);

    JGEvent& operator=(const JGEvent& rhs);

    JGid& ceid()              { return m_id; }
    void   ceid(JGid& id)     { m_id = id; }
    bool enabled() const      { return m_enabled; }
    void enabled(bool status) { m_enabled = status; }
    JGReports * reportSet()   { return &m_rptset; }
    void clearReports()       { m_rptset.clear(); }
    bool isDeleted() const    { return (m_rptset.size() == 0); }
    const string& category() const   { return m_category; }
    const string& actionName() const { return m_action; }
    void  manager(JGEventManager * mngr) { m_manager = mngr; }

    void insert(JGReport * report) { m_rptset.push_back(report); }
    int  erase(JGReport * report);
    bool exist(JGid& report);

    BS2Item * createReports(void * arg = NULL);

private:
    void copy(const JGEvent& rhs);

protected:
    bool   m_enabled;
    string m_category;
    string m_action;
    //
    JGEventManager * m_manager;
    JGReports m_rptset;

};

//
//
//
class JGEvtReport
{
public:
    JGEvtReport() : m_ceid("0"), m_rptid("0"), m_seqnum(0) {}

    JGid& ceid()  { return m_ceid; }
    JGid& rptid() { return m_rptid; }
    void ceid(JGid& id)  { m_ceid = id; }
    void rptid(JGid& id) { m_rptid = id; }

protected:
    JGid m_ceid;
    JGid m_rptid;
    int  m_seqnum;

};

typedef map<string, JGid, str_less, allocator<JGid> >    JGActionTable;
typedef map<JGid, JGEvent, id_less, allocator<JGEvent> > JGEventTable;
typedef JGActionTable::value_type  JGActionPair;
typedef JGEventTable::value_type  JGEventPair;
typedef vector<JGEvent *> JGEvents;
typedef list<JGEvent *>   JGEventList;

#endif  /* JGEVENT_H */
