// $Id: JGInfoManager.h,v 1.1 2003/02/09 16:16:13 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGInfoManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGINFOMANAGER_H
#define JGINFOMANAGER_H

#include "JGManager.h"
#include "JGVariable.h"
#include "JGConfig.h"
#include "JGTriggerInfo.h"
#include "JGDefineVariable.h"
#include "sac/JGIODevice.h"

class BS2Item;
struct DeviceParameter;

/*
 * Reosource class
 */
class BEE_Export JGInfoManager: public JGManager
{
public:
    JGInfoManager();
    ~JGInfoManager();

    virtual int init(void * = 0);
    virtual int open(void * = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int notify(const string& category, JGVariable * var,
                       void * arg = NULL);

    int initConfig(int = 0);

    const string& getConf(const string& pname);
    const string& getConf(const BCHAR * pname) {
            string nameStr = pname;
            return this->getConf(nameStr);
        }
    JGVariable * variable(const string& vname);
    JGVariable * variable(const BCHAR * vname) {
            string nameStr = vname;
            return this->variable(nameStr);
        }
    JGVariable * variable(const JGid& vid);
    JGvalue&     value(const string& vname);
    JGvalue&     value(const BCHAR * vname) {
            string nameStr = vname;
            return this->value(nameStr);
        }
    JGvalue&     value(const JGid& vid);
    JGVariable * variableBySvid(JGid& svid);
    JGVariable * variableByEcid(JGid& ecid);
    BS2Item *    find(JGid& vid);
    int          initVariables();
    DeviceParameter * getDeviceParameter();

    JGConfigTable * configTable() { return &m_configs; }
    JGVariableTable * varTable()  { return &m_vars; }
    JGVarNameTable * nameTable()  { return &m_varnames; }
    JGVidTable * svTable()  { return &m_svs; }
    JGVidTable * ecvTable() { return &m_ecvs; }

    int monitor();   // Monitor equipment constant variables
    static JGInfoManager * instance();

private:
    void linkConf();
    void confVariables();
    void linkVariables();
    BS2Message * selEquipmentStatus(BS2Message * msg);
    BS2Message * svNameList(BS2Message * msg);
    BS2Message * equipmentConstant(BS2Message * msg);
    BS2Message * newEquipmentConstant(BS2Message * msg);
    BS2Message * ecvNameList(BS2Message * msg);

//
private:
    JGConfigTable   m_configs;
    JGVariableTable m_vars;
    JGVarNameTable  m_varnames;
    JGVidTable m_svs;
    JGVidTable m_ecvs;

    // = ACE_Thread_Mutex and condition variable for synchronizing termination.
    ACE_Thread_Mutex m_confLock;
    ACE_Thread_Mutex m_varLock;

    JGVariable * m_ecvStatus;
    ACE_Thread_Mutex m_lock;           // Lock for ECV monitor

};

#endif
