// $Id: JGManager.h,v 1.3 2003/02/16 17:04:53 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGMANAGER_H
#define JGMANAGER_H

#include "jyugem.h"
#include "JGStateTask.h"
#include "JGDefineEvent.h"
#include "JGDefineTrigger.h"
#include "JGDefineVariable.h"

#ifndef CATEGORY_IGNORE
#define CATEGORY_IGNORE        _TX("IGNORE")
#define CATEGORY_ACCESS        _TX("ACCESS")
#define CATEGORY_ALARM         _TX("ALARM")
#define CATEGORY_COMM          _TX("COMMUNICATION")
#define CATEGORY_CONTROL       _TX("CONTROL")
#define CATEGORY_EVENT         _TX("EVENT")
#define CATEGORY_LIMIT         _TX("LIMIT")
#define CATEGORY_MATERIAL      _TX("MATERIAL")
#define CATEGORY_MATEIO        _TX("MATEIO")
#define CATEGORY_MATEMOVE      _TX("MATEMOVE")
#define CATEGORY_PROCESS       _TX("PROCESS")
#define CATEGORY_PROCPROG      _TX("PROCPROG")
#define CATEGORY_RECIPE        _TX("RECIPE")
#define CATEGORY_RCPEXE        _TX("RCPEXE")
#define CATEGORY_RESOURCE      _TX("RESOURCE")
#define CATEGORY_SPOOL         _TX("SPOOL")
#define CATEGORY_TERMINAL      _TX("TERMINAL")
#define CATEGORY_TRACE         _TX("TRACE")
#define CATEGORY_RCMD          _TX("RCMD")
#define CATEGORY_INFO          _TX("INFO")
#define CATEGORY_CLOCK         _TX("CLOCK")
#define CATEGORY_IODEVICE      _TX("IODEVICE")
#define CATEGORY_OBJECT        _TX("OBJECT")
#define CATEGORY_CONTROLJOB    _TX("CONTROLJOB")
#define CATEGORY_PROCESSJOB    _TX("PROCESSJOB")
#define CATEGORY_ARAMS         _TX("ARAMS")
#endif

// Forward declaration
class JGVariable;
class JGEquipment;
class JGObserver;
class JGCommDevice;
class JGMessageTrigger;
class JGDeviceTrigger;
class JGNotifyTrigger;
class JGOperatorTrigger;
class JGService;
class BS2Message;
class BS2MessageInfo;
class BS2Item;

//-----------------------------------------------------------------------------
//
// GEM Management class
//
//-----------------------------------------------------------------------------
class BEE_Export JGManager: public JGTask
{
    friend class JGMessageRequest;
    friend class JGDeviceRequest;
    friend class JGOperatorRequest;
    friend class JGNotifyRequest;
    friend class JGRemoteRequest;

public:
    JGManager(const string& name);
    virtual ~JGManager();

    virtual int init(void * = 0);
    virtual int open(void * = 0);     // start service thread
    virtual int close(int = 0);
    virtual int svc(void);

    // for state model
    virtual int notify(JGTrigger * trigger);
    virtual int notify(const string& category);
    virtual int notify(const string& category, JGVariable * var,
                       void * arg);
    int notify(BS2MessageInfo& msginfo);
    int notify(JGService * rcmd);
    int start() { return this->notify(TRIGGER_START); }
    int stop()  { return this->notify(TRIGGER_FINISH); }

    int send(BS2Message * msg);   // Send SECS Message
                                  // Send Event Message
    int sendEvent(const string& evtid, JGVariable * var = NULL);

    void equipment(JGEquipment * equip) { m_equipment = equip; }
    void device(JGCommDevice * dev)     { m_device = dev; }
    void stateTask(JGStateTask * st)    { m_hsmTask = st; }
    JGEquipment * equipment() { return m_equipment; }
    JGCommDevice * device()   { return m_device; }
    JGStateTask * stateTask() { return m_hsmTask; }
    BS2Item * getDataID();

    static JGManager * instance(const string& category);

//
protected:
    BS2Message * unrecognized(BS2Message *);  // Make unrecognized message

    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int device_svc(JGDeviceTrigger * trigger);  // trigger from I/O devices
    virtual int notify_svc(JGNotifyTrigger * trigger);
    virtual int ope_svc(JGOperatorTrigger * trigger);
    virtual int rcmd_svc(JGService * trigger);

protected:
    JGEquipment *  m_equipment;
    JGCommDevice * m_device;
    JGStateTask *  m_hsmTask;

};


#endif
