// $Id: JGProcessManager.h,v 1.7 2003/02/23 11:00:18 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGProcessManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGPROCESSMANAGER_H
#define JGPROCESSMANAGER_H

#include "JGManager.h"

class JGProcess;

/*
 * Process Manager Class (Container of JGProcess)
 */
class BEE_Export JGProcessManager : public JGManager
{
public:
    JGProcessManager();
    virtual ~JGProcessManager() {}

    virtual int init(void * = 0);
    virtual int open(void * = 0);     // start service thread

    virtual int notify(const string& category, JGVariable * var,
                       void * arg = NULL);
    virtual int notify(JGService * rcmd);

    bool isActive();

    static JGProcessManager * instance();

private:

// member variables
private:
    vector<JGProcess *> m_procs;

};

#endif
