// $Id: JGRecipe.h,v 1.6 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGRecipe.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGRECIPE_H
#define JGRECIPE_H

#include "JGVariable.h"
#include "JGClass.h"
#include "JGObject.h"
#include "JGService.h"

#define ATTR_PARAMETERS  _TX("Parameters")

class JGRecipeClass;
class BS2Message;
class BS2Item;

// Define an object to hold configure data
class JGRecipe : public JGObject
{
    friend class JGRecipeManager;
public:
    enum { SOURCE = 0, OBJ = 1 };
    enum {                              // Change Status
        NO_CHANGE    = 0,
        CREATED      = 1,
        UPDATED      = 2,
        STORED       = 3,
        REPLACED     = 4,
        DELETED      = 5,
        COPIED       = 6,
        RENAMED      = 7,
        UNPROTECTED  = 8,
        PROTECTED    = 9,
        VERIFIED     = 10,
        LINKED       = 11,
        UNLINKED     = 12,
        CERTIFIED    = 13,
        DECERTIFIED  = 14,
        SELECTED     = 15,
        DESELECTED   = 16,
    };

public:
    JGRecipe(JGClass * clazz, const BCHAR * name = NULL) :
             JGObject(clazz, name) {}
    ~JGRecipe() {}

    JGid    rcpid();
    size_t  bodyLength();

    int set(vector<JGAttrFilter>& filter,        // from host messag
            JGErrorList& errlist);

protected:
    vector<RCmdParam> m_params;
};

typedef map<JGid, JGRecipe *, id_less, allocator<JGRecipe *> > JGRecipeTable;
typedef JGRecipeTable::value_type  JGRecipePair;
typedef vector<JGRecipe *>         JGRecipes;
typedef list<JGRecipe *>           JGRecipeList;

#endif  /* JGRECIPE_H */
