// $Id: JGReport.cpp,v 1.5 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGReport.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGReport.h"
#include "JGVariable.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"

//-----------------------------------------------------------------------------
// Copy
//-----------------------------------------------------------------------------
JGReport& JGReport::operator=(const JGReport& rhs)
{
    TRACE_FUNCTION(TRL_LOW, "JGReport::operator=");
    if (this == &rhs)
        return *this;
    this->copy(rhs);
    return *this;
}

//-----------------------------------------------------------------------------
void JGReport::copy(const JGReport& rhs)
{
    TRACE_FUNCTION(TRL_LOW, "JGReport::copy");
    this->JGNameInfo::copy(rhs);
    m_vids = rhs.m_vids;
    return ;
}

//-----------------------------------------------------------------------------
// Erase variable data.
//-----------------------------------------------------------------------------
int JGReport::erase(JGVariable * variable)
{
    TRACE_FUNCTION(TRL_LOW, "JGReport::erase");

    JGVariables::iterator iter = m_vids.begin();
    for ( ; iter != m_vids.end(); ++iter)
    {
        JGVariable * var = *iter;
        if ((var == variable) || (var->vid() == variable->vid()))
        {
            m_vids.erase(iter);
            return BEE_SUCCESS;
        }
    }

    return BEE_ERROR;
}

//-----------------------------------------------------------------------------
bool JGReport::exist(JGid& vid)
{
    TRACE_FUNCTION(TRL_LOW, "JGReport::exist");

    JGVariables::iterator iter = m_vids.begin();
    for ( ; iter != m_vids.end(); ++iter)
    {
        JGVariable * var = *iter;
        if (var->vid() == vid)
        {
            return true;
        }
    }

    return false;
}

//-----------------------------------------------------------------------------
// Create report data.
//-----------------------------------------------------------------------------
BS2Item * JGReport::create(void * arg)
{
    TRACE_FUNCTION(TRL_LOW, "JGReport::create");
    BS2ListItem * listitem = new BS2ListItem();
    BS2Item * item;

    item = BS2Item::factory(_TX("RPTID"), m_id);
    listitem->add(item);

    item = this->makeVList(arg);        // make value list
    listitem->add(item);

    return listitem;
}

//-----------------------------------------------------------------------------
// Make value list in the report.
//-----------------------------------------------------------------------------
BS2Item * JGReport::makeVList(void * arg)
{
    TRACE_FUNCTION(TRL_LOW, "JGReport::makeVList");
    BS2Item * item;
    BS2ListItem * vlist = new BS2ListItem();
    JGVariables::iterator iter = m_vids.begin();
    for ( ; iter != m_vids.end(); ++iter)
    {
        JGVariable * var = *iter;
        item = var->createVItem(arg);
        vlist->add(item);
    }
    return vlist;
}

//-----------------------------------------------------------------------------
// Print items of the report
//-----------------------------------------------------------------------------
void JGReport::printOn(string& buf, int mode)
{
    TRACE_FUNCTION(TRL_LOW, "JGReport::printOn");
    ACE_UNUSED_ARG(mode);

    string vidStr;
    m_id.get(buf);
    buf += " {";
    // variable ids
    JGVariables::iterator iter = m_vids.begin();
    for ( ; iter != m_vids.end(); ++iter)
    {
        JGVariable * var = *iter;
        var->vid().get(vidStr);
        buf += vidStr;
        buf += _TX(" ");
    }
    buf += _TX("}");

    return ;
}

