// $Id: JGResourceManager.cpp,v 1.9 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGResourceManager.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGResourceManager.h"
#include "JGEquipment.h"
#include "sac/JGIODevManager.h"


static JGResourceManager * _manager = NULL;


//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
JGResourceManager::JGResourceManager() : JGManager(CATEGORY_RESOURCE)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGResourceManager::JGResourceManager");

}

//-----------------------------------------------------------------------------
JGResourceManager::~JGResourceManager()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGResourceManager::~JGResourceManager");

}

//-----------------------------------------------------------------------------
// Return own.
//-----------------------------------------------------------------------------
JGResourceManager * JGResourceManager::instance()
{
    TRACE_FUNCTION(TRL_LOW, "JGResourceManager::instance");
    if (_manager == NULL)
    {
        _manager = new JGResourceManager;
    }
    return _manager;
}


//-----------------------------------------------------------------------------
// Initialize
//-----------------------------------------------------------------------------
int JGResourceManager::init(void * parm)
{
    TRACE_FUNCTION(TRL_LOW, "JGResourceManager::init");
    ACE_UNUSED_ARG(parm);

    // Initial modules (Process chamber, Load Port, ...)
    JGSubSystemTable::iterator iter = m_modules.begin();
    for ( ; iter != m_modules.end(); iter++)
    {
        JGSubSystem * subsys = (*iter).second;
        subsys->init();
    }
    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Find Subsystem by ID
//-----------------------------------------------------------------------------
JGSubSystem * JGResourceManager::findSubSystem(JGid& id)
{
    TRACE_FUNCTION(TRL_LOW, "JGResourceManager::findSubSystem");

    JGSubSystemTable::iterator iter = m_modules.find(id);
    if (iter == m_modules.end())
    {
        return NULL;
    }
    JGSubSystem * subsys = (*iter).second;
    return subsys;
}

//-----------------------------------------------------------------------------
// Accept trigger from the variable.
//-----------------------------------------------------------------------------
int JGResourceManager::notify(const string& category, JGVariable * var,
                              void * arg)
{
    TRACE_FUNCTION(TRL_LOW, "JGLimitManager::notify");
    ACE_UNUSED_ARG(arg);

    int result;

    TRACE_ERROR((_TX("%s : %s = %s\n"), category.c_str(), var->charName(),
                                        var->getv().toString().c_str()));

    {
        TRACE_ERROR((_TX("Not implement: %s\n"), category.c_str()));
        result = BEE_ERROR;
    }
    return result;
}

//-----------------------------------------------------------------------------
// Thread of received message event.
//-----------------------------------------------------------------------------
BS2Message * JGResourceManager::msg_svc(JGMessageTrigger * trigger,
                                        BS2Message * msg)
{
    ACE_UNUSED_ARG(trigger);
    ACE_UNUSED_ARG(msg);
    BS2Message * replymsg = NULL;

    return replymsg;
}

