// $Id: JGService.h,v 1.2 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGService.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGSERVICE_H
#define JGSERVICE_H

#include "jyugem.h"
#include "JGCommand.h"
#include "JGErrorList.h"

//
// Service command
//
class BEE_Export JGService : public JGCommand
{
public:
    JGService() : JGCommand() {}
    JGService(const string& cmd) : JGCommand(cmd) {}
    JGService(const string& cmd, JGObject * obj) : JGCommand(cmd, obj) {}
    JGService(const string& cmd, JGObject * obj, const string& dest,
              const string& from) : JGCommand(cmd, obj, dest, from) {}
    JGService(const string& cmd, const string& dest, const string& from)
            : JGCommand(cmd, dest, from) {}
    JGService(JGCommand * src, JGErrorList * errs)
            : JGCommand(*src), m_errors(*errs) {}
    JGService(const JGService& rhs) 
            : JGCommand((const JGCommand&)rhs), m_errors(rhs.m_errors) {}

    JGService& operator=(const JGService& rhs) {
            if (this == &rhs)
                return *this;
            this->JGTrigger::copy(rhs);
            m_errors = rhs.m_errors;
            return *this;
        }

protected:
    JGErrorList m_errors;
};

#endif  /* JGSERVICE_H */
