// $Id: JGServiceManager.h,v 1.2 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGServiceManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGSERVICEMANAGER_H
#define JGSERVICEMANAGER_H

#include "JGManager.h"

class JGServiceManager;

//-----------------------------------------------------------------------------
//
// Save the request which response is taken a log tame
//
//-----------------------------------------------------------------------------
class JGOperationInfo
{
public:
    JGServiceManager * m_manager;
    UINT m_opid;
    int  m_tmid;
    BS2Message * m_msg;

    JGOperationInfo() : m_manager(NULL), m_opid(0), m_tmid(0), m_msg(NULL) {}
    JGOperationInfo(JGServiceManager * manager, UINT opid,
                    BS2Message * msg = NULL)
            : m_manager(manager), m_opid(opid), m_tmid(0), m_msg(msg) {}
    JGOperationInfo(const JGOperationInfo& rhs) {
            m_manager = rhs.m_manager;
            m_opid = rhs.m_opid;
            m_tmid = rhs.m_tmid;
            m_msg = rhs.m_msg;
        }
    JGOperationInfo& operator=(const JGOperationInfo& rhs) {
            if (this == &rhs)
                return *this;
            m_manager = rhs.m_manager;
            m_opid = rhs.m_opid;
            m_tmid = rhs.m_tmid;
            m_msg = rhs.m_msg;
            return *this;
        }

    virtual void timeout() {}
    virtual void call() {}
};

typedef map<UINT, JGOperationInfo *, uint_less, allocator<JGOperationInfo *> >
        JGOperationTable;
typedef JGOperationTable::value_type  JGOperationPair;


//-----------------------------------------------------------------------------
//
// Service Management class
//
//-----------------------------------------------------------------------------
class BEE_Export JGServiceManager: public JGManager
{
public:
    JGServiceManager(const string& name);
    virtual ~JGServiceManager() {}

    int attach(JGObserver * observer);
    int detach(JGObserver * observer);

    void opid(UINT id);
    UINT opid();
    int  entryOperation(JGOperationInfo * ope);
    int  removeOperation(UINT opid);
    JGOperationInfo * findOperation(UINT opid);

//
protected:

// variables
protected:
    JGTask * m_assistant;
    JGTriggerFuture m_future;

    ACE_Thread_Mutex m_lock;
    JGOperationTable m_opes;
};


#endif
