// $Id: JGStateTask.h,v 1.3 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGStateTask.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGSTATETASK_H
#define JGSTATETASK_H

#include "jyugem.h"
#include "state/b_context.h"
#include "state/b_transition.h"
#include "JGTask.h"
#include "JGTrigger.h"

#ifndef TRIGGER_INITIAL
#define TRIGGER_INITIAL            _TX("INITIAL")
#define STATE_ROOT                 _TX("/")
#endif

typedef b_state JGState;
class JGManager;
class JGEquipment;

//-----------------------------------------------------------------------------
//
// State Context
//
//-----------------------------------------------------------------------------
class BEE_Export JGStateTask : public b_context, public JGTask
{
    class BEE_Export ChangeStateRequest : public JGTriggerRequest
    {
    public:
        ChangeStateRequest(JGTrigger * trigger, JGTask * task = NULL)
                : JGTriggerRequest(trigger, task) {}
        virtual ~ChangeStateRequest(void) {}
        virtual int call(void);

    private:
    };

public:
    JGStateTask(const string& name) : b_context(name), JGTask(name), m_thread(false) {}
    ~JGStateTask() {}

    const BCHAR * charName() { return this->b_context::name().c_str(); }
    const string& name()     { return this->b_context::name(); }

    // virtual method of MT_Task
    virtual int init(void * = 0);
    virtual int open(void * = 0);
    virtual int close(int = 0);
    virtual int svc(void);

    // virtual method of StateTask
    virtual int initTransitions() { return 0; }

    int notify(ChangeStateRequest * trig);
    virtual int notify(const string& category) {
            JGTrigger * trig = new JGTrigger(category);
            return this->notify(new ChangeStateRequest(trig, this));
        }
    virtual int notify(JGTrigger * trig) {
            return this->notify(new ChangeStateRequest(trig, this));
        }

    int firstStep() {               // first event
            return this->notify(TRIGGER_INITIAL);
        }

    JGEquipment * equipment() { return m_equipment; }
    void equipment(JGEquipment * equip) { m_equipment = equip; }
    void dump() const { this->b_context::dump(); }

    static RootState Root;

protected:
    JGStateTask() : b_context(_TX("")), JGTask(_TX("")), m_thread(false) {}

//
protected:
    bool m_thread;
    JGEquipment * m_equipment;
};

template<class T>
class JGStateTask_T : public JGStateTask
{
public:
    JGStateTask_T(const string& name) : JGStateTask(name) {}
    T *  manager() { return m_manager; }
    void manager(T * mngr) { m_manager = mngr; mngr->stateTask(this); }
protected:
    T * m_manager;
};

#ifndef DEF_STATE_MODEL
#define DEF_STATE_MODEL

//-----------------------------------------------------------------------------
//
//
// MACRO DEFINITIONS
//
//Define root state class
#define MANAGER_STATE(CLS,P,N)                                                 \
    class CLS;                                                                 \
    class P;                                                                   \
    typedef ACE_Singleton<CLS, ACE_Null_Mutex> _##CLS;                         \
    typedef JGStateTask_T<P> JGStateTask_##CLS;                                \
    class CLS: public JGStateTask_##CLS                                        \
    {                                                                          \
        friend class ACE_Singleton<CLS, ACE_Null_Mutex>;                       \
        friend class P;                                                        \
    public:                                                                    \
        CLS() : JGStateTask_##CLS(N) {}                                        \
        virtual ~CLS() {}                                                      \
        virtual int initTransitions();                                         \
        virtual int unexpect(b_trigger * trigger);                             \
        typedef b_condnode<CLS> ConditionNode;                                 \
        typedef b_edgenode<CLS> EdgeNode;

//
#define OBJECT_STATE(CLS,P,N)                                                  \
    class CLS;                                                                 \
    class P;                                                                   \
    typedef JGStateTask_T<P> JGStateTask_##CLS;                                \
    class CLS: public  JGStateTask_##CLS                                       \
    {                                                                          \
        friend class P;                                                        \
    public:                                                                    \
        P * m_obj;                                                             \
    public:                                                                    \
        CLS() : JGStateTask_##CLS(N) {}                                        \
        virtual ~CLS() {}                                                      \
        virtual int initTransitions();                                         \
        virtual int unexpect(b_trigger * trigger);                             \
        typedef b_condnode<CLS> ConditionNode;                                 \
        typedef b_edgenode<CLS> EdgeNode;



#define END_ROOT_STATE()                                                       \
    };

// Define state class for conndition node
// These macros must be declared after STATIC_ROOT_STATE or ROOT_STATE
#define CONDITION_STATE(CLS)                                                   \
    class CLS##State : public ConditionNode {                                  \
    public:                                                                    \
        CLS##State(b_statype * base, b_context * root)                         \
                : ConditionNode(base, root) {}                                 \
        virtual ~CLS##State() {}                                               \
        virtual const BCHAR * next(b_trigger * trigger) {                      \
            return root()->act##CLS((JGTrigger *)trigger);                     \
        }                                                                      \
    };                                                                         \
    typedef b_condstate<CLS##State>  CLS;                                      \
    const BCHAR * act##CLS(JGTrigger *);

// Define state class
// These macros must be declared after STATIC_ROOT_STATE or ROOT_STATE
//
#define EDGE_STATE(CLS)                                                        \
    class CLS##State : public EdgeNode {                                       \
    public:                                                                    \
        CLS##State(b_statype * base, b_context * root)                         \
                : EdgeNode(base, root) {}                                      \
        virtual ~CLS##State() {}                                               \
        virtual int begin(b_state * prev, b_trigger * trig) {                  \
                return root()->act##CLS((JGState *)prev, (JGTrigger *)trig);   \
            }                                                                  \
    };                                                                         \
    typedef b_edge<CLS##State>   CLS;                                          \
    friend class CLS##State;                                                   \
    int act##CLS(JGState * prev, JGTrigger * trigger);

#define EDGE_STATE_ID(CLS,ID)                                                  \
    class CLS##State : public EdgeNode {                                       \
    public:                                                                    \
        CLS##State(b_statype * base, b_context * root)                         \
                : EdgeNode(base, root) {}                                      \
        virtual ~CLS##State() {}                                               \
        virtual int begin(b_state * prev, b_trigger * trig) {                  \
                return root()->act##CLS((JGState *)prev, (JGTrigger *)trig);   \
            }                                                                  \
    };                                                                         \
    typedef b_edge<CLS##State>   CLS;                                          \
    friend class CLS##State;                                                   \
    int act##CLS(JGState * prev, JGTrigger * trigger);

//
#define EDGE_STATE_EX(CLS)                                                     \
    class CLS##State : public EdgeNode {                                       \
    public:                                                                    \
        CLS##State(b_statype * base, b_context * root)                         \
                : EdgeNode(base, root) { base->setIdx(ID); }                   \
        virtual ~CLS##State() {}                                               \
        virtual int begin(b_state * prev, b_trigger * trig) {                  \
                return root()->act##CLS((JGState *)prev, (JGTrigger *)trig);   \
            }                                                                  \
        virtual int end(b_trigger * trigger) {                                 \
                return root()->end##CLS((JGTrigger *)trigger);                 \
            }                                                                  \
    };                                                                         \
    typedef b_edge<CLS##State>   CLS;                                          \
    friend class CLS##State;                                                   \
    int act##CLS(JGState * prev, JGTrigger * trigger);                         \
    int end##CLS(JGTrigger * trigger);

#define EDGE_STATE_ID_EX(CLS,ID)                                               \
    class CLS##State : public EdgeNode {                                       \
    public:                                                                    \
        CLS##State(b_statype * base, b_context * root)                         \
                : EdgeNode(base, root) { base->setIdx(ID); }                   \
        virtual ~CLS##State() {}                                               \
        virtual int begin(b_state * prev, b_trigger * trig) {                  \
                return root()->act##CLS((JGState *)prev, (JGTrigger *)trig);   \
            }                                                                  \
        virtual int end(b_trigger * trigger) {                                 \
                return root()->end##CLS((JGTrigger *)trigger);                 \
            }                                                                  \
    };                                                                         \
    typedef b_edge<CLS##State>   CLS;                                          \
    friend class CLS##State;                                                   \
    int act##CLS(JGState * prev, JGTrigger * trigger);                         \
    int end##CLS(JGTrigger * trigger);

//
//
//
#define DEF_ACTION(CLS,p)                                                      \
    static const BCHAR * _act##p(b_context * root, b_trigger * trigger) {      \
        return ((CLS *)root)->p((JGTrigger *)trigger);                         \
    }

//
//
//
#define BEGIN_STATIC_STATE_TABLE(CLS)                                          \
    static _##CLS * singleton_;                                                \
    static const BCHAR * _actNULL(b_context * root, b_trigger * trigger) {     \
        ACE_UNUSED_ARG(singleton_);                                            \
        ACE_UNUSED_ARG(root);                                                  \
        ACE_UNUSED_ARG(trigger);                                               \
        return NULL;                                                           \
    }                                                                          \
    int CLS::initTransitions() {                                               \
        b_state * state;                                                       \
        b_transition * trans;

#define BEGIN_STATE_TABLE(CLS)                                                 \
    static const BCHAR * _actNULL(b_context * root, b_trigger * trigger) {     \
        ACE_UNUSED_ARG(root);                                                  \
        ACE_UNUSED_ARG(trigger);                                               \
        return NULL;                                                           \
    }                                                                          \
    int CLS::initTransitions() {                                               \
        b_state * state;                                                       \
        b_transition * trans;

//
//   define node transitions
#define NODE_TRANSITION(s,d)                                                   \
    trans = new b_transition(d, s, "", _actNULL);                              \
    state = (b_state *)((s)->create(this));                                    \
    this->append(state, "", trans);

//
//   define transitions
#define ACT_TRANSITION(s,t,p,d)                                                \
    trans = new b_transition(d, s, t, _act##p);                                \
    state = (b_state *)((s)->create(this));                                    \
    this->append(state, t, trans);

//
//   define transitions
#define NEXT_TRANSITION(s,t,x,d)                                               \
    trans = new b_nextransit(d, s, t, x);                                      \
    state = (b_state *)((s)->create(this));                                    \
    this->append(state, t, trans);

// end definition
#define END_STATE_TABLE()                                                      \
        this->makeStateTable();                                                \
        return 0;                                                              \
    }

#endif

#endif  /* JGSTATETASK_H */
