// $Id: JGSubSystem.h,v 1.5 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGSubSystem.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGSUBSYSTEM_H
#define JGSUBSYSTEM_H

#include "jyugem.h"
#include "JGVariable.h"
#include "JGNameInfo.h"
#include "sac/JGIODevice.h"

// Define an object to hold configure data
class JGSubSystem : public JGNameInfo
{
    friend class JGResourceManager;
public:
    enum
    {   // SubSystem Type
        UNKNOWN = 0, LOADPORT = 1, LOADLOCK = 2, PROCESS = 3, TRANSFER = 4,
        ALIGNER = 5
    };

public:
    JGSubSystem(const BCHAR * name, int type)
            : JGNameInfo(name), m_systype(type), m_relocNum(0) {}
    JGSubSystem(const JGSubSystem& rhs);
    virtual ~JGSubSystem() {}

    JGSubSystem& operator=(const JGSubSystem& rhs) {
            if (this == &rhs)
                return *this;
            copy(rhs);
            return *this;
        }

    JGid& subsysid()         { return m_id; }
    void  subsysid(JGid& id) { m_id = id; }
    JGid& locid()            { return m_locid; }
    void  locid(JGid& id)    { m_locid = id; }
    void  subSystemType(int t) { m_systype = t; }
    int   subSystemType() const { return m_systype; }
    int   relocationNum() const { return m_relocNum; }
    void  relocationNum(int n)  {  m_relocNum = n; }
    int   add(JGIODevice * iodev) {
            m_sacs.insert(JGSacPair(iodev->devid(), iodev));
            return BEE_SUCCESS;
        }

    virtual int  init() { return BEE_SUCCESS; }
    virtual void set(const JGSubSystem& rhs) { this->operator=(rhs); }

protected:
    JGSubSystem() : JGNameInfo(), m_systype(UNKNOWN), m_relocNum(0) {}
    void copy(const JGSubSystem& rhs);

//
protected:
    JGid m_locid;
    int  m_systype;
    int  m_relocNum;
    JGSacMap m_sacs;
};

typedef map<JGid, JGSubSystem *, id_less, allocator<JGSubSystem *> >
        JGSubSystemTable;
typedef JGSubSystemTable::value_type  JGSubSystemPair;
typedef vector<JGSubSystem *> JGSubSystems;
typedef list<JGSubSystem *>   JGSubSystemList;

#endif  /* JGSUBSYSTEM_H */
