// $Id: JGVariable.h,v 1.3 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGVariable.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGVARIABLE_H
#define JGVARIABLE_H

#include "jyugem.h"
#include "JGNameInfo.h"

class JGIODevice;
class BS2Item;
class BS2Atom;
class JGVariable;
class JGTriggerInfo;
class JGLimit;

typedef BS2Atom * (*vfptr)(JGVariable * fgvar, void * arg);

//
class BEE_Export JGVariable : public JGNameInfo
{
public:
    enum { NONE, SVID, ECID };
    enum { V=0, SV=1, ECV=2, DVVAL=3, PV=4 };

public:
    JGVariable() : JGNameInfo(),
                   m_ecsvid(0), m_class(0), m_valtype(0), m_size(0),
                   m_value(_TX("")), m_unit(_TX("")), m_itemname(_TX("")),
                   m_func(_TX("")), m_trgid(_TX("")), m_offset(0),
                   m_limitEnabled(false), m_enabled(false), m_save(false),
                   m_hostupd(false), m_iodev(), m_initval(0), m_minval(0),
                   m_maxval(0), m_funcptr(NULL), m_limit(NULL),
                   m_sac(NULL) {}
    virtual ~JGVariable() {}
    JGVariable& operator=(const JGVariable& rhs);
    JGVariable& operator=(BS2Atom * atom);
    virtual void  printOn(string& buf, int mode = 0);

    JGid& vid()         { return m_id; }
    void  vid(JGid& id) { m_id = id; }
    JGid& svid()        { return m_ecsvid; }
    JGid& ecid()        { return m_ecsvid; }
    void  user_id(JGid& id) { m_ecsvid = id; }
    const string& trgid() const { return m_trgid; }
    const string& func() const  { return m_func; }
    const string& itemName() const { return m_itemname; }
    int   varclass() const  { return m_class; }
    int   format() const    { return m_valtype; }
    int   offset() const    { return m_offset; }
    bool  enabled() const   { return m_enabled; }
    void  funcptr(vfptr fptr) { m_funcptr = fptr; }
    JGTriggerInfo * trginfo() const { return m_trginfo; }
    JGLimit *       limit() const   { return m_limit; }
    const JGid&     iodev() const   { return m_iodev; }
    JGIODevice *    sac() const     { return m_sac; }
    void  trginfo(JGTriggerInfo * info);
    void  limit(JGLimit * liminfo) { m_limit = liminfo; }
    void  iodev(JGid& ioid)        { m_iodev = ioid; }
    void  sac(JGIODevice * ioptr)  { m_sac = ioptr; }

    int   init();
    int   sense();
    bool  validValue(JGvalue& val, int type = -1); // Is the value in range ?
    bool  changed();                 // get and compare the last value
    int   trigger();                 // call event action
    void  refresh(JGvalue& val) {
            m_lastval = m_curval; m_curval = val; m_hostupd = false;
        }
    void  setInt(int val);
    void  setv(JGvalue& val, bool hostupd = false);
    JGvalue& getv();
    void curval(JGvalue& val) { m_lastval = m_curval; m_curval = val; }
    JGvalue& curval()         { return m_curval; }
    JGvalue& lastval()        { return m_lastval; }
    BS2Atom * getAtom(void * arg = NULL);
    int  inc();        // increment current value
    int  dec();        // decrement current value
    int  add(int n);
    int  sub(int n);

    BS2Item * createVItem(void * arg = NULL);
    BS2Item * createNameItem();                // for S1F12
    BS2Item * createEcvName();                 // for S2F30

    static BS2Item * nilNameItem(JGid& svid);  // for S1F12
    static BS2Item * nilEcvName(JGid& ecid);   // for S2F30

protected:
    void copy(const JGVariable& rhs);

protected:
    JGid   m_ecsvid;
    int    m_class;                            // SV,ECV,DVVAL,PV
    int    m_valtype;                          // ATOM_XXXXX
    int    m_size;
    string m_value;
    string m_unit;
    string m_itemname;
    string m_func;
    string m_trgid;
    int    m_offset;
    bool   m_limitEnabled;
    bool   m_enabled;
    bool   m_save;
    MUTEX_Bool m_hostupd;

    JGid    m_iodev;
    JGvalue m_initval;
    JGvalue m_minval;
    JGvalue m_maxval;

    //
    JGTriggerInfo * m_trginfo;
    BS2ids   m_ids;
    JGvalue  m_curval;
    JGvalue  m_lastval;
    vfptr    m_funcptr;
    JGLimit * m_limit;
    JGIODevice * m_sac;
};

typedef map<JGid, JGVariable, id_less, allocator<JGVariable> >
        JGVariableTable;
typedef map<string, JGVariable *, str_less, allocator<JGVariable *> >
        JGVarNameTable;
typedef map<JGid, JGVariable *, id_less, allocator<JGVariable *> >
        JGVidTable;
typedef JGVariableTable::value_type  JGVarPair;
typedef JGVarNameTable::value_type   JGVarNamePair;
typedef JGVidTable::value_type       JGVidPair;
typedef list<JGVariable *>   JGVariableList;
typedef vector<JGVariable *> JGVariables;


#endif  /* JGVARIABLE_H */
